"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _table_cell_actions = require("./table_cell_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TableCell = props => {
  const classes = (0, _classnames.default)({
    ['eui-textNoWrap kbnDocTableCell--extraWidth']: props.timefield,
    ['eui-textBreakAll eui-textBreakWord']: props.sourcefield,
    ['kbnDocTableCell__dataField eui-textBreakAll eui-textBreakWord']: !props.timefield && !props.sourcefield
  });
  const handleFilterFor = () => props.inlineFilter(props.column, '+');
  const handleFilterOut = () => props.inlineFilter(props.column, '-');
  return /*#__PURE__*/_react.default.createElement("td", {
    className: classes,
    "data-test-subj": "docTableField"
  }, props.formatted, props.filterable ? /*#__PURE__*/_react.default.createElement(_table_cell_actions.TableCellActions, {
    handleFilterOut: handleFilterOut,
    handleFilterFor: handleFilterFor
  }) : /*#__PURE__*/_react.default.createElement("span", {
    className: "kbnDocTableCell__filter"
  }));
};
exports.TableCell = TableCell;