"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Resource = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var constants = _interopRequireWildcard(require("../../../../../common/data_types/logs/constants"));
var _resource = require("./utils/resource");
var _popover_chip = require("../../../data_types/logs/popover_chip");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const AgentIcon = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/custom-icons/src/components/agent_icon'))));
const Resource = ({
  row
}) => {
  const resourceDoc = (0, _resource.getUnformattedResourceFields)(row);
  return /*#__PURE__*/_react.default.createElement("div", null, resourceDoc[constants.SERVICE_NAME_FIELD] && /*#__PURE__*/_react.default.createElement(_popover_chip.ChipWithPopover, {
    property: constants.SERVICE_NAME_FIELD,
    text: resourceDoc[constants.SERVICE_NAME_FIELD],
    rightSideIcon: "arrowDown",
    leftSideIcon: resourceDoc[constants.AGENT_NAME_FIELD] && /*#__PURE__*/_react.default.createElement(AgentIcon, {
      agentName: resourceDoc[constants.AGENT_NAME_FIELD],
      size: "m"
    })
  }), resourceDoc[constants.CONTAINER_NAME_FIELD] && /*#__PURE__*/_react.default.createElement(_popover_chip.ChipWithPopover, {
    property: constants.CONTAINER_NAME_FIELD,
    text: resourceDoc[constants.CONTAINER_NAME_FIELD],
    rightSideIcon: "arrowDown"
  }), resourceDoc[constants.HOST_NAME_FIELD] && /*#__PURE__*/_react.default.createElement(_popover_chip.ChipWithPopover, {
    property: constants.HOST_NAME_FIELD,
    text: resourceDoc[constants.HOST_NAME_FIELD],
    rightSideIcon: "arrowDown"
  }), resourceDoc[constants.ORCHESTRATOR_NAMESPACE_FIELD] && /*#__PURE__*/_react.default.createElement(_popover_chip.ChipWithPopover, {
    property: constants.ORCHESTRATOR_NAMESPACE_FIELD,
    text: resourceDoc[constants.ORCHESTRATOR_NAMESPACE_FIELD],
    rightSideIcon: "arrowDown"
  }), resourceDoc[constants.CLOUD_INSTANCE_ID_FIELD] && /*#__PURE__*/_react.default.createElement(_popover_chip.ChipWithPopover, {
    property: constants.CLOUD_INSTANCE_ID_FIELD,
    text: resourceDoc[constants.CLOUD_INSTANCE_ID_FIELD],
    rightSideIcon: "arrowDown"
  }));
};
exports.Resource = Resource;