"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Content = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _discoverUtils = require("@kbn/discover-utils");
var _i18n = require("@kbn/i18n");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var constants = _interopRequireWildcard(require("../../../../../common/data_types/logs/constants"));
var _log_level = require("../../../data_types/logs/log_level");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const SourceDocument = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/unified-data-table/src/components/source_document'))));
const DiscoverSourcePopoverContent = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/unified-data-table/src/components/source_popover_content'))));
const sourceDocumentClassName = (0, _css.css)`
  display: inline !important;
  margin-left: ${_uiTheme.euiThemeVars.euiSizeXS};
`;
const LogMessage = ({
  field,
  value
}) => {
  const renderFieldPrefix = field && field !== constants.MESSAGE_FIELD;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    style: {
      display: 'inline',
      marginLeft: '5px'
    }
  }, renderFieldPrefix && /*#__PURE__*/_react.default.createElement("strong", {
    "data-test-subj": "discoverDataTableMessageKey"
  }, field), /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "discoverDataTableMessageValue",
    style: {
      marginLeft: '5px'
    }
  }, value));
};
const SourcePopoverContent = ({
  row,
  columnId,
  closePopover
}) => {
  const closeButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('discover.logs.grid.closePopover', {
      defaultMessage: `Close popover`
    }),
    "data-test-subj": "docTableClosePopover",
    iconSize: "s",
    iconType: "cross",
    size: "xs",
    onClick: closePopover
  });
  return /*#__PURE__*/_react.default.createElement(DiscoverSourcePopoverContent, {
    row: row,
    columnId: columnId,
    closeButton: closeButton,
    useTopLevelObjectColumns: false
  });
};
const Content = ({
  row,
  dataView,
  fieldFormats,
  isDetails,
  columnId,
  closePopover
}) => {
  const documentOverview = (0, _discoverUtils.getLogDocumentOverview)(row, {
    dataView,
    fieldFormats
  });
  const {
    field,
    value
  } = (0, _discoverUtils.getMessageFieldWithFallbacks)(documentOverview);
  const renderLogMessage = field && value;
  const shouldShowFieldHandler = (0, _react.useMemo)(() => {
    const dataViewFields = dataView.fields.getAll().map(fld => fld.name);
    return (0, _discoverUtils.getShouldShowFieldHandler)(dataViewFields, dataView, true);
  }, [dataView]);
  const formattedRow = (0, _react.useMemo)(() => {
    return formatJsonDocumentForContent(row);
  }, [row]);
  if (isDetails && !renderLogMessage) {
    return /*#__PURE__*/_react.default.createElement(SourcePopoverContent, {
      row: formattedRow,
      columnId: columnId,
      closePopover: closePopover
    });
  }
  return /*#__PURE__*/_react.default.createElement("span", null, documentOverview[constants.LOG_LEVEL_FIELD] && /*#__PURE__*/_react.default.createElement(_log_level.LogLevel, {
    level: documentOverview[constants.LOG_LEVEL_FIELD]
  }), renderLogMessage ? /*#__PURE__*/_react.default.createElement(LogMessage, {
    field: field,
    value: value
  }) : /*#__PURE__*/_react.default.createElement(SourceDocument, {
    useTopLevelObjectColumns: false,
    row: formattedRow,
    dataView: dataView,
    columnId: columnId,
    fieldFormats: fieldFormats,
    shouldShowFieldHandler: shouldShowFieldHandler,
    maxEntries: 50,
    dataTestSubj: "discoverCellDescriptionList",
    className: sourceDocumentClassName
  }));
};
exports.Content = Content;
const formatJsonDocumentForContent = row => {
  const flattenedResult = {};
  const rawFieldResult = {};
  const {
    raw,
    flattened
  } = row;
  const {
    fields
  } = raw;

  // We need 2 loops here for flattened and raw.fields. Flattened contains all fields,
  // whereas raw.fields only contains certain fields excluding _ignored
  for (const key in flattened) {
    if (!constants.FILTER_OUT_FIELDS_PREFIXES_FOR_CONTENT.some(prefix => key.startsWith(prefix))) {
      flattenedResult[key] = flattened[key];
    }
  }
  for (const key in fields) {
    if (!constants.FILTER_OUT_FIELDS_PREFIXES_FOR_CONTENT.some(prefix => key.startsWith(prefix))) {
      rawFieldResult[key] = fields[key];
    }
  }
  return {
    ...row,
    flattened: flattenedResult,
    raw: {
      ...raw,
      fields: rawFieldResult
    }
  };
};