"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResourceColumnTooltip = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _translations = require("../../../../data_types/logs/translations");
var constants = _interopRequireWildcard(require("../../../../../../common/data_types/logs/constants"));
var _tooltip_button = require("./tooltip_button");
var _field_with_token = require("./field_with_token");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const spacingCSS = (0, _react2.css)`
  margin-bottom: ${_uiTheme.euiThemeVars.euiSizeS};
`;
const ResourceColumnTooltip = ({
  column,
  headerRowHeight
}) => {
  return /*#__PURE__*/_react.default.createElement(_tooltip_button.TooltipButton, {
    displayText: column.displayAsText,
    headerRowHeight: headerRowHeight,
    popoverTitle: _translations.resourceLabel
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '230px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: spacingCSS
  }, /*#__PURE__*/_react.default.createElement("p", null, _translations.resourceHeaderTooltipParagraph)), [constants.SERVICE_NAME_FIELD, constants.CONTAINER_NAME_FIELD, constants.ORCHESTRATOR_NAMESPACE_FIELD, constants.HOST_NAME_FIELD, constants.CLOUD_INSTANCE_ID_FIELD].map(field => /*#__PURE__*/_react.default.createElement(_field_with_token.FieldWithToken, {
    field: field,
    key: field
  }))));
};
exports.ResourceColumnTooltip = ResourceColumnTooltip;