"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../../common/data_types/logs/constants");
var _content_column_tooltip = require("./column_tooltips/content_column_tooltip");
var _resource_column_tooltip = require("./column_tooltips/resource_column_tooltip");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const renderColumn = field => ({
  column,
  headerRowHeight
}) => {
  switch (field) {
    case _constants.CONTENT_FIELD:
      column.display = /*#__PURE__*/_react.default.createElement(_content_column_tooltip.ContentColumnTooltip, {
        column: column,
        headerRowHeight: headerRowHeight
      });
      break;
    case _constants.RESOURCE_FIELD:
      column.display = /*#__PURE__*/_react.default.createElement(_resource_column_tooltip.ResourceColumnTooltip, {
        column: column,
        headerRowHeight: headerRowHeight
      });
      break;
    default:
      break;
  }
  return column;
};
exports.renderColumn = renderColumn;