"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_virtual_column_services = require("../../../../application/main/hooks/grid_customisations/use_virtual_column_services");
var _constants = require("../../../../../common/data_types/logs/constants");
var _content = require("./content");
var _resource = require("./resource");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const renderCell = (type, {
  data
}) => props => {
  const {
    dataView
  } = props;
  const virtualColumnServices = {
    data,
    dataView
  };
  let renderedCell = null;
  switch (type) {
    case _constants.CONTENT_FIELD:
      renderedCell = /*#__PURE__*/_react.default.createElement(_content.Content, props);
      break;
    case _constants.RESOURCE_FIELD:
      renderedCell = /*#__PURE__*/_react.default.createElement(_resource.Resource, props);
      break;
    default:
      break;
  }
  return /*#__PURE__*/_react.default.createElement(_use_virtual_column_services.VirtualColumnServiceProvider, {
    services: virtualColumnServices
  }, renderedCell);
};
exports.renderCell = renderCell;