"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChipWithPopover = ChipWithPopover;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _translations = require("./translations");
var _filter_in_button = require("./filter_in_button");
var _filter_out_button = require("./filter_out_button");
var _copy_button = require("./copy_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const DataTablePopoverCellValue = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/unified-data-table/src/components/data_table_cell_value'))));
function ChipWithPopover({
  property,
  text,
  dataTestSubj = `dataTablePopoverChip_${property}`,
  leftSideIcon,
  rightSideIcon,
  borderColor,
  style,
  shouldRenderPopover = true
}) {
  const xsFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const handleChipClick = (0, _react.useCallback)(() => {
    if (!shouldRenderPopover) return;
    setIsPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen, shouldRenderPopover]);
  const closePopover = () => setIsPopoverOpen(false);
  const chipContent = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    iconType: rightSideIcon,
    iconSide: "right",
    "data-test-subj": dataTestSubj,
    onClick: handleChipClick,
    onClickAriaLabel: _translations.openCellActionPopoverAriaText,
    css: (0, _react2.css)`
        ${borderColor ? `border: 2px solid ${borderColor};` : ''}
        font-size: ${xsFontSize};
        display: flex;
        justify-content: center;
        ${shouldRenderPopover && `margin-right: 4px; margin-top: -3px;`}
        cursor: pointer;
      `,
    style: style
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, leftSideIcon && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, leftSideIcon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, text)));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: chipContent,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downCenter",
    panelPaddingSize: "s",
    panelStyle: {
      minWidth: '24px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "row",
    responsive: false,
    "data-test-subj": "dataTableCellActionPopoverTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      maxWidth: '200px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(DataTablePopoverCellValue, null, /*#__PURE__*/_react.default.createElement("span", {
    style: {
      fontWeight: 700
    }
  }, property), " ", text)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _translations.closeCellActionPopoverText,
    "data-test-subj": "dataTableExpandCellActionPopoverClose",
    iconSize: "s",
    iconType: "cross",
    size: "xs",
    onClick: closePopover
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_filter_in_button.FilterInButton, {
    value: text,
    property: property
  }), /*#__PURE__*/_react.default.createElement(_filter_out_button.FilterOutButton, {
    value: text,
    property: property
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_copy_button.CopyButton, {
    value: text,
    property: property
  }))));
}