"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogLevel = LogLevel;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var constants = _interopRequireWildcard(require("../../../../common/data_types/logs/constants"));
var _popover_chip = require("./popover_chip");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LEVEL_DICT = {
  error: 'danger',
  warn: 'warning',
  info: 'primary',
  debug: 'accent'
};
function LogLevel({
  level,
  dataTestSubj,
  renderInFlyout = false
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!level) return null;
  const levelColor = LEVEL_DICT[level] ? euiTheme.colors[LEVEL_DICT[level]] : null;
  const truncatedLogLevel = level.length > 10 ? level.substring(0, 10) + '...' : level;
  if (renderInFlyout) {
    return /*#__PURE__*/_react.default.createElement(_popover_chip.ChipWithPopover, {
      property: constants.LOG_LEVEL_FIELD,
      text: truncatedLogLevel,
      borderColor: levelColor,
      style: {
        width: 'none'
      },
      dataTestSubj: dataTestSubj,
      shouldRenderPopover: !renderInFlyout
    });
  }
  return /*#__PURE__*/_react.default.createElement(_popover_chip.ChipWithPopover, {
    property: constants.LOG_LEVEL_FIELD,
    text: level,
    rightSideIcon: "arrowDown",
    borderColor: levelColor,
    style: {
      width: '80px',
      marginTop: '-3px'
    }
  });
}