"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterOutButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/data-plugin/public");
var _use_virtual_column_services = require("../../../application/main/hooks/grid_customisations/use_virtual_column_services");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FilterOutButton = ({
  property,
  value
}) => {
  const ariaFilterOutText = (0, _translations.actionFilterOutText)(value);
  const serviceContext = (0, _use_virtual_column_services.useVirtualColumnServiceContext)();
  const filterManager = serviceContext === null || serviceContext === void 0 ? void 0 : serviceContext.data.query.filterManager;
  const dataView = serviceContext.dataView;
  const onFilterOutAction = () => {
    if (filterManager != null) {
      const filter = (0, _public.generateFilters)(filterManager, property, [value], '-', dataView);
      filterManager.addFilters(filter);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: "removeFromFilterAction"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "minusInCircle",
    "aria-label": ariaFilterOutText,
    onClick: onFilterOutAction,
    "data-test-subj": `dataTableCellAction_removeFromFilterAction_${property}`
  }, _translations.filterOutText));
};
exports.FilterOutButton = FilterOutButton;