"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CopyButton = ({
  property,
  value
}) => {
  const ariaCopyValueText = (0, _translations.copyValueAriaText)(property);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: "copyToClipboardAction"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "copyClipboard",
    "aria-label": ariaCopyValueText,
    onClick: () => (0, _eui.copyToClipboard)(value),
    "data-test-subj": `dataTableCellAction_copyToClipboardAction_${property}`
  }, _translations.copyValueText));
};
exports.CopyButton = CopyButton;