"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorCallout = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _searchErrors = require("@kbn/search-errors");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _use_discover_services = require("../../hooks/use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ErrorCallout = ({
  title,
  error
}) => {
  var _searchErrorDisplay$t, _searchErrorDisplay$a, _searchErrorDisplay$b;
  const {
    core
  } = (0, _use_discover_services.useDiscoverServices)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const searchErrorDisplay = (0, _searchErrors.renderSearchError)(error);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "error",
    color: "danger",
    title: /*#__PURE__*/_react2.default.createElement("h2", {
      "data-test-subj": "discoverErrorCalloutTitle"
    }, (_searchErrorDisplay$t = searchErrorDisplay === null || searchErrorDisplay === void 0 ? void 0 : searchErrorDisplay.title) !== null && _searchErrorDisplay$t !== void 0 ? _searchErrorDisplay$t : title),
    actions: (_searchErrorDisplay$a = searchErrorDisplay === null || searchErrorDisplay === void 0 ? void 0 : searchErrorDisplay.actions) !== null && _searchErrorDisplay$a !== void 0 ? _searchErrorDisplay$a : [],
    body: /*#__PURE__*/_react2.default.createElement("div", {
      css: (0, _react.css)`
            text-align: left;
          `
    }, (_searchErrorDisplay$b = searchErrorDisplay === null || searchErrorDisplay === void 0 ? void 0 : searchErrorDisplay.body) !== null && _searchErrorDisplay$b !== void 0 ? _searchErrorDisplay$b : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("p", {
      css: (0, _react.css)`
                  white-space: break-spaces;
                  word-wrap: break-word;
                  font-family: ${euiTheme.font.familyCode};
                `,
      "data-test-subj": "discoverErrorCalloutMessage"
    }, error.message), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      onClick: () => core.notifications.showErrorDialog({
        title,
        error
      })
    }, _i18n.i18n.translate('discover.errorCalloutShowErrorMessage', {
      defaultMessage: 'View details'
    }))))
  });
};
exports.ErrorCallout = ErrorCallout;