"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValidViewMode = void 0;
var _public = require("@kbn/saved-search-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Returns a valid view mode
 * @param viewMode
 * @param isEsqlMode
 */
const getValidViewMode = ({
  viewMode,
  isEsqlMode
}) => {
  if (viewMode === _public.VIEW_MODE.PATTERN_LEVEL && isEsqlMode) {
    // only this mode is supported for ES|QL languages
    return _public.VIEW_MODE.DOCUMENT_LEVEL;
  }
  return viewMode;
};
exports.getValidViewMode = getValidViewMode;