"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getResultState = getResultState;
exports.resultStatuses = void 0;
var _types = require("../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const resultStatuses = exports.resultStatuses = {
  UNINITIALIZED: 'uninitialized',
  LOADING: 'loading',
  // initial data load
  READY: 'ready',
  // results came back
  NO_RESULTS: 'none' // no results came back
};

/**
 * Returns the current state of the result, depends on fetchStatus and the given fetched rows
 * Determines what is displayed in Discover main view (loading view, data view, empty data view, ...)
 */
function getResultState(fetchStatus, foundDocuments = false) {
  if (fetchStatus === _types.FetchStatus.UNINITIALIZED) {
    return resultStatuses.UNINITIALIZED;
  }
  if (fetchStatus === _types.FetchStatus.ERROR) return resultStatuses.NO_RESULTS;
  if (!foundDocuments && fetchStatus === _types.FetchStatus.LOADING) return resultStatuses.LOADING;else if (foundDocuments) return resultStatuses.READY;else if (fetchStatus === _types.FetchStatus.PARTIAL) return resultStatuses.READY;else return resultStatuses.NO_RESULTS;
}