"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateTimeRange = validateTimeRange;
var _i18n = require("@kbn/i18n");
var _validate_time = require("../../../../utils/validate_time");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Validates a given time filter range, provided by URL or UI
 * Unless valid, it returns false and displays a notification
 */
function validateTimeRange({
  from,
  to
}, toastNotifications) {
  if (!(0, _validate_time.isTimeRangeValid)({
    from,
    to
  })) {
    toastNotifications.addDanger({
      title: _i18n.i18n.translate('discover.notifications.invalidTimeRangeTitle', {
        defaultMessage: `Invalid time range`
      }),
      text: _i18n.i18n.translate('discover.notifications.invalidTimeRangeText', {
        defaultMessage: `The provided time range is invalid. (from: ''{from}'', to: ''{to}'')`,
        values: {
          from,
          to
        }
      })
    });
    return false;
  }
  return true;
}