"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataViewAppState = getDataViewAppState;
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
var _sorting = require("../../../../utils/sorting");
var _data_sources = require("../../../../../common/data_sources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Helper function to remove or adapt the currently selected columns/sort to be valid with the next
 * data view, returns a new state object
 */
function getDataViewAppState(currentDataView, nextDataView, defaultColumns, currentColumns, currentSort, modifyColumns = true, sortDirection = 'desc', query) {
  let columns = currentColumns || [];
  if (modifyColumns) {
    const currentUnknownColumns = columns.filter(column => !currentDataView.fields.getByName(column) && !defaultColumns.includes(column));
    const currentColumnsRefreshed = (0, _lodash.uniq)([...columns, ...defaultColumns]);
    columns = currentColumnsRefreshed.filter(column => nextDataView.fields.getByName(column) || currentUnknownColumns.includes(column));
  }
  const isEsqlQuery = (0, _esQuery.isOfAggregateQueryType)(query);
  if (isEsqlQuery) {
    columns = [];
  }

  // when switching from an data view with timeField to an data view without timeField
  // filter out sorting by timeField in case it is set. data views without timeField don't
  // prepend this field in the table, so in legacy grid you would need to add this column to
  // remove sorting
  let nextSort = (0, _sorting.getSortArray)(currentSort, nextDataView, isEsqlQuery).filter(value => {
    return nextDataView.timeFieldName || value[0] !== currentDataView.timeFieldName;
  });
  if (nextDataView.isTimeBased() && !nextSort.length) {
    // set default sorting if it was not set
    nextSort = [[nextDataView.timeFieldName, sortDirection]];
  } else if (nextDataView.isTimeBased() && currentDataView.isTimeBased() && nextDataView.timeFieldName !== currentDataView.timeFieldName) {
    // switch time fields
    nextSort = nextSort.map(cur => cur[0] === currentDataView.timeFieldName ? [nextDataView.timeFieldName, cur[1]] : cur);
  }
  return {
    dataSource: nextDataView.id ? (0, _data_sources.createDataViewDataSource)({
      dataViewId: nextDataView.id
    }) : undefined,
    columns,
    sort: nextSort
  };
}