"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInspector = useInspector;
var _react = require("react");
var _aggregate_request_adapter = require("../utils/aggregate_request_adapter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function useInspector({
  inspector,
  stateContainer
}) {
  const [inspectorSession, setInspectorSession] = (0, _react.useState)(undefined);
  const onOpenInspector = (0, _react.useCallback)(() => {
    // prevent overlapping
    stateContainer.internalState.transitions.setExpandedDoc(undefined);
    const inspectorAdapters = stateContainer.dataState.inspectorAdapters;
    const requestAdapters = inspectorAdapters.lensRequests ? [inspectorAdapters.requests, inspectorAdapters.lensRequests] : [inspectorAdapters.requests];
    const session = inspector.open({
      requests: new _aggregate_request_adapter.AggregateRequestAdapter(requestAdapters)
    }, {
      title: stateContainer.savedSearchState.getTitle()
    });
    setInspectorSession(session);
  }, [stateContainer, inspector]);
  (0, _react.useEffect)(() => {
    return () => {
      if (inspectorSession) {
        // Close the inspector if this scope is destroyed (e.g. because the user navigates away).
        inspectorSession.close();
      }
    };
  }, [inspectorSession]);
  return onOpenInspector;
}