"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAdHocDataViews = void 0;
var _react = require("react");
var _analytics = require("@kbn/analytics");
var _discover_state_provider = require("../state_management/discover_state_provider");
var _discover_internal_state_container = require("../state_management/discover_internal_state_container");
var _constants = require("../../../constants");
var _use_filters_validation = require("./use_filters_validation");
var _use_is_esql_mode = require("./use_is_esql_mode");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useAdHocDataViews = ({
  services
}) => {
  const dataView = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.dataView);
  const savedSearch = (0, _discover_state_provider.useSavedSearch)();
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  const {
    filterManager,
    toastNotifications
  } = services;
  (0, _react.useEffect)(() => {
    if (dataView && !dataView.isPersisted()) {
      var _services$trackUiMetr;
      (_services$trackUiMetr = services.trackUiMetric) === null || _services$trackUiMetr === void 0 ? void 0 : _services$trackUiMetr.call(services, _analytics.METRIC_TYPE.COUNT, _constants.ADHOC_DATA_VIEW_RENDER_EVENT);
    }
  }, [dataView, isEsqlMode, services]);

  /**
   * Takes care of checking data view id references in filters
   */
  (0, _use_filters_validation.useFiltersValidation)({
    savedSearch,
    filterManager,
    toastNotifications
  });
};
exports.useAdHocDataViews = useAdHocDataViews;