"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAdditionalFieldGroups = void 0;
var _common = require("@kbn/data-views-plugin/common");
var _react = require("react");
var _customizations = require("../../../../customizations");
var constants = _interopRequireWildcard(require("../../../../../common/data_types/logs/constants"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useAdditionalFieldGroups = () => {
  var _useDiscoverCustomiza;
  // TODO / NOTE: This will eventually rely on Discover's context resolution to determine which fields
  // are returned based on the data type.
  const isLogsContext = (_useDiscoverCustomiza = (0, _customizations.useDiscoverCustomization)('field_list')) === null || _useDiscoverCustomiza === void 0 ? void 0 : _useDiscoverCustomiza.logsFieldsEnabled;
  const fields = (0, _react.useMemo)(() => {
    if (isLogsContext) {
      const smartFields = [new _common.DataViewField({
        name: constants.RESOURCE_FIELD,
        type: 'smart_field',
        searchable: false,
        aggregatable: false
      }), new _common.DataViewField({
        name: constants.CONTENT_FIELD,
        type: 'smart_field',
        searchable: false,
        aggregatable: false
      })];
      // For functionality that cannot support smart fields, we need to provide fallback fields.
      const fallbackFields = {
        [constants.RESOURCE_FIELD]: constants.RESOURCE_FIELD_CONFIGURATION.fallbackFields,
        [constants.CONTENT_FIELD]: constants.CONTENT_FIELD_CONFIGURATION.fallbackFields
      };
      return {
        smartFields,
        fallbackFields
      };
    }
  }, [isLogsContext]);
  return fields;
};
exports.useAdditionalFieldGroups = useAdditionalFieldGroups;