"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogsVirtualColumnsConfiguration = exports.createCustomGridColumnsConfiguration = exports.createCustomCellRenderer = void 0;
var _constants = require("../../../../../common/data_types/logs/constants");
var _cell_renderer = require("../../../../components/discover_grid/virtual_columns/logs/cell_renderer");
var _column = require("../../../../components/discover_grid/virtual_columns/logs/column");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getLogsVirtualColumnsConfiguration = data => {
  return {
    customCellRenderer: createCustomCellRenderer({
      data
    }),
    customGridColumnsConfiguration: createCustomGridColumnsConfiguration()
  };
};
exports.getLogsVirtualColumnsConfiguration = getLogsVirtualColumnsConfiguration;
const createCustomCellRenderer = ({
  data
}) => {
  return {
    [_constants.CONTENT_FIELD]: (0, _cell_renderer.renderCell)(_constants.CONTENT_FIELD, {
      data
    }),
    [_constants.RESOURCE_FIELD]: (0, _cell_renderer.renderCell)(_constants.RESOURCE_FIELD, {
      data
    })
  };
};
exports.createCustomCellRenderer = createCustomCellRenderer;
const createCustomGridColumnsConfiguration = () => ({
  [_constants.CONTENT_FIELD]: (0, _column.renderColumn)(_constants.CONTENT_FIELD),
  [_constants.RESOURCE_FIELD]: (0, _column.renderColumn)(_constants.RESOURCE_FIELD)
});
exports.createCustomGridColumnsConfiguration = createCustomGridColumnsConfiguration;