"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateVolatileSearchSource = updateVolatileSearchSource;
var _public = require("@kbn/data-views-plugin/public");
var _discoverUtils = require("@kbn/discover-utils");
var _sorting = require("../../../utils/sorting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Helper function to update the given searchSource before fetching/sharing/persisting
 */
function updateVolatileSearchSource(searchSource, {
  dataView,
  services,
  sort,
  customFilters
}) {
  const {
    uiSettings,
    data
  } = services;
  const useNewFieldsApi = !uiSettings.get(_discoverUtils.SEARCH_FIELDS_FROM_SOURCE);
  const usedSort = (0, _sorting.getSortForSearchSource)({
    sort,
    dataView,
    defaultSortDir: uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING),
    includeTieBreaker: true
  });
  searchSource.setField('sort', usedSort);
  searchSource.setField('trackTotalHits', true);
  let filters = [...customFilters];
  if (dataView.type !== _public.DataViewType.ROLLUP) {
    // Set the date range filter fields from timeFilter using the absolute format. Search sessions requires that it be converted from a relative range
    const timeFilter = data.query.timefilter.timefilter.createFilter(dataView);
    filters = timeFilter ? [...filters, timeFilter] : filters;
  }
  searchSource.setField('filter', filters);
  if (useNewFieldsApi) {
    searchSource.removeField('fieldsFromSource');
    searchSource.setField('fields', [{
      field: '*',
      include_unmapped: true
    }]);
  } else {
    searchSource.removeField('fields');
  }
}