"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchEsql = fetchEsql;
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function fetchEsql({
  query,
  inputQuery,
  filters,
  dataView,
  abortSignal,
  inspectorAdapters,
  data,
  expressions,
  profilesManager
}) {
  const timeRange = data.query.timefilter.timefilter.getTime();
  return (0, _common.textBasedQueryStateToAstWithValidation)({
    filters,
    query,
    time: timeRange,
    dataView,
    inputQuery,
    titleForInspector: _i18n.i18n.translate('discover.inspectorEsqlRequestTitle', {
      defaultMessage: 'Table'
    }),
    descriptionForInspector: _i18n.i18n.translate('discover.inspectorEsqlRequestDescription', {
      defaultMessage: 'This request queries Elasticsearch to fetch results for the table.'
    })
  }).then(ast => {
    if (ast) {
      const contract = expressions.execute(ast, null, {
        inspectorAdapters
      });
      abortSignal === null || abortSignal === void 0 ? void 0 : abortSignal.addEventListener('abort', contract.cancel);
      const execution = contract.getData();
      let finalData = [];
      let esqlQueryColumns;
      let error;
      let esqlHeaderWarning;
      execution.pipe((0, _rxjs.pluck)('result')).subscribe(resp => {
        const response = resp;
        if (response.type === 'error') {
          error = response.error.message;
        } else {
          var _table$rows, _table$columns, _table$warning;
          const table = response;
          const rows = (_table$rows = table === null || table === void 0 ? void 0 : table.rows) !== null && _table$rows !== void 0 ? _table$rows : [];
          esqlQueryColumns = (_table$columns = table === null || table === void 0 ? void 0 : table.columns) !== null && _table$columns !== void 0 ? _table$columns : undefined;
          esqlHeaderWarning = (_table$warning = table.warning) !== null && _table$warning !== void 0 ? _table$warning : undefined;
          finalData = rows.map((row, idx) => {
            const record = {
              id: String(idx),
              raw: row,
              flattened: row
            };
            return profilesManager.resolveDocumentProfile({
              record
            });
          });
        }
      });
      return (0, _rxjs.lastValueFrom)(execution).then(() => {
        if (error) {
          throw new Error(error);
        } else {
          return {
            records: finalData || [],
            esqlQueryColumns,
            esqlHeaderWarning
          };
        }
      });
    }
    return {
      records: [],
      esqlQueryColumns: [],
      esqlHeaderWarning: undefined
    };
  }).catch(err => {
    throw new Error(err.message);
  });
}