"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverTopNav = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/data-views-plugin/public");
var _esqlUtils = require("@kbn/esql-utils");
var _discover_state_provider = require("../../state_management/discover_state_provider");
var _discover_internal_state_container = require("../../state_management/discover_internal_state_container");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _on_save_search = require("./on_save_search");
var _customizations = require("../../../../customizations");
var _add_log = require("../../../../utils/add_log");
var _discover_app_state_container = require("../../state_management/discover_app_state_container");
var _use_discover_topnav = require("./use_discover_topnav");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DiscoverTopNav = ({
  savedQuery,
  stateContainer,
  esqlModeErrors,
  esqlModeWarning,
  onFieldEdited,
  isLoading,
  onCancelClick
}) => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    dataViewEditor,
    navigation,
    dataViewFieldEditor,
    data,
    uiSettings,
    dataViews,
    setHeaderActionMenu
  } = services;
  const query = (0, _discover_app_state_container.useAppStateSelector)(state => state.query);
  const adHocDataViews = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.adHocDataViews);
  const dataView = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.dataView);
  const savedDataViews = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.savedDataViews);
  const savedSearch = (0, _discover_state_provider.useSavedSearchInitial)();
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  const showDatePicker = (0, _react.useMemo)(() => {
    // always show the timepicker for ES|QL mode
    return isEsqlMode || !isEsqlMode && dataView.isTimeBased() && dataView.type !== _public.DataViewType.ROLLUP;
  }, [dataView, isEsqlMode]);
  const closeFieldEditor = (0, _react.useRef)();
  const closeDataViewEditor = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    return () => {
      // Make sure to close the editors when unmounting
      if (closeFieldEditor.current) {
        closeFieldEditor.current();
      }
      if (closeDataViewEditor.current) {
        closeDataViewEditor.current();
      }
    };
  }, []);
  const canEditDataView = Boolean(dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.userPermissions.editDataView()) || !dataView.isPersisted();
  const editField = (0, _react.useMemo)(() => canEditDataView ? async (fieldName, uiAction = 'edit') => {
    if (dataView !== null && dataView !== void 0 && dataView.id) {
      const dataViewInstance = await data.dataViews.get(dataView.id);
      closeFieldEditor.current = await dataViewFieldEditor.openEditor({
        ctx: {
          dataView: dataViewInstance
        },
        fieldName,
        onSave: async () => {
          await onFieldEdited();
        }
      });
    }
  } : undefined, [canEditDataView, dataView === null || dataView === void 0 ? void 0 : dataView.id, data.dataViews, dataViewFieldEditor, onFieldEdited]);
  const addField = (0, _react.useMemo)(() => canEditDataView && editField ? () => editField(undefined, 'add') : undefined, [editField, canEditDataView]);
  const createNewDataView = (0, _react.useCallback)(() => {
    closeDataViewEditor.current = dataViewEditor.openEditor({
      onSave: stateContainer.actions.onDataViewCreated,
      allowAdHocDataView: true
    });
  }, [dataViewEditor, stateContainer]);
  const onEditDataView = (0, _react.useCallback)(async editedDataView => {
    if (editedDataView.isPersisted()) {
      // Clear the current data view from the cache and create a new instance
      // of it, ensuring we have a new object reference to trigger a re-render
      dataViews.clearInstanceCache(editedDataView.id);
      stateContainer.actions.setDataView(await dataViews.create(editedDataView.toSpec(), true));
    } else {
      await stateContainer.actions.updateAdHocDataViewId();
    }
    stateContainer.actions.loadDataViewList();
    (0, _add_log.addLog)('[DiscoverTopNav] onEditDataView triggers data fetching');
    stateContainer.dataState.fetch();
  }, [dataViews, stateContainer.actions, stateContainer.dataState]);
  const updateSavedQueryId = newSavedQueryId => {
    const {
      appState
    } = stateContainer;
    if (newSavedQueryId) {
      appState.update({
        savedQuery: newSavedQueryId
      });
    } else {
      // remove savedQueryId from state
      const newState = {
        ...appState.getState()
      };
      delete newState.savedQuery;
      appState.set(newState);
    }
  };
  const onEsqlSavedAndExit = (0, _react.useCallback)(({
    onSave,
    onCancel
  }) => {
    (0, _on_save_search.onSaveSearch)({
      savedSearch: stateContainer.savedSearchState.getState(),
      services,
      state: stateContainer,
      onClose: onCancel,
      onSaveCb: onSave
    });
  }, [services, stateContainer]);
  const {
    topNavBadges,
    topNavMenu
  } = (0, _use_discover_topnav.useDiscoverTopNav)({
    stateContainer
  });
  const topNavProps = (0, _react.useMemo)(() => {
    if (stateContainer.customizationContext.inlineTopNav.enabled) {
      return undefined;
    }
    return {
      badges: topNavBadges,
      config: topNavMenu,
      setMenuMountPoint: setHeaderActionMenu
    };
  }, [setHeaderActionMenu, stateContainer.customizationContext.inlineTopNav.enabled, topNavBadges, topNavMenu]);
  const savedSearchId = (0, _discover_state_provider.useSavedSearch)().id;
  const savedSearchHasChanged = (0, _discover_state_provider.useSavedSearchHasChanged)();
  const dataViewPickerProps = (0, _react.useMemo)(() => {
    const isESQLModeEnabled = uiSettings.get(_esqlUtils.ENABLE_ESQL);
    const supportedTextBasedLanguages = isESQLModeEnabled ? [_esqlUtils.TextBasedLanguages.ESQL] : [];
    return {
      trigger: {
        label: (dataView === null || dataView === void 0 ? void 0 : dataView.getName()) || '',
        'data-test-subj': 'discover-dataView-switch-link',
        title: (dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern()) || ''
      },
      currentDataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
      onAddField: addField,
      onDataViewCreated: createNewDataView,
      onCreateDefaultAdHocDataView: stateContainer.actions.createAndAppendAdHocDataView,
      onChangeDataView: stateContainer.actions.onChangeDataView,
      textBasedLanguages: supportedTextBasedLanguages,
      shouldShowTextBasedLanguageTransitionModal: !savedSearchId || savedSearchHasChanged,
      adHocDataViews,
      savedDataViews,
      onEditDataView
    };
  }, [adHocDataViews, addField, createNewDataView, dataView, onEditDataView, savedDataViews, savedSearchHasChanged, savedSearchId, stateContainer, uiSettings]);
  const searchBarCustomization = (0, _customizations.useDiscoverCustomization)('search_bar');
  const SearchBar = (0, _react.useMemo)(() => {
    var _searchBarCustomizati;
    return (_searchBarCustomizati = searchBarCustomization === null || searchBarCustomization === void 0 ? void 0 : searchBarCustomization.CustomSearchBar) !== null && _searchBarCustomizati !== void 0 ? _searchBarCustomizati : navigation.ui.AggregateQueryTopNavMenu;
  }, [searchBarCustomization === null || searchBarCustomization === void 0 ? void 0 : searchBarCustomization.CustomSearchBar, navigation.ui.AggregateQueryTopNavMenu]);
  const shouldHideDefaultDataviewPicker = !!(searchBarCustomization !== null && searchBarCustomization !== void 0 && searchBarCustomization.CustomDataViewPicker) || !!(searchBarCustomization !== null && searchBarCustomization !== void 0 && searchBarCustomization.hideDataViewPicker);
  return /*#__PURE__*/_react.default.createElement(SearchBar, (0, _extends2.default)({}, topNavProps, {
    appName: "discover",
    indexPatterns: [dataView],
    onQuerySubmit: stateContainer.actions.onUpdateQuery,
    onCancel: onCancelClick,
    isLoading: isLoading,
    onSavedQueryIdChange: updateSavedQueryId,
    query: query,
    savedQueryId: savedQuery,
    screenTitle: savedSearch.title,
    showDatePicker: showDatePicker,
    saveQueryMenuVisibility: services.capabilities.discover.saveQuery ? 'allowed_by_app_privilege' : 'globally_managed',
    showSearchBar: true,
    useDefaultBehaviors: true,
    dataViewPickerOverride: searchBarCustomization !== null && searchBarCustomization !== void 0 && searchBarCustomization.CustomDataViewPicker ? /*#__PURE__*/_react.default.createElement(searchBarCustomization.CustomDataViewPicker, null) : undefined,
    dataViewPickerComponentProps: shouldHideDefaultDataviewPicker ? undefined : dataViewPickerProps,
    displayStyle: "detached",
    textBasedLanguageModeErrors: esqlModeErrors ? [esqlModeErrors] : undefined,
    textBasedLanguageModeWarning: esqlModeWarning,
    onTextBasedSavedAndExit: onEsqlSavedAndExit,
    prependFilterBar: searchBarCustomization !== null && searchBarCustomization !== void 0 && searchBarCustomization.PrependFilterBar ? /*#__PURE__*/_react.default.createElement(searchBarCustomization.PrependFilterBar, null) : undefined
  }));
};
exports.DiscoverTopNav = DiscoverTopNav;