"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverSidebarReducerStatus = exports.DiscoverSidebarReducerActionType = void 0;
exports.discoverSidebarReducer = discoverSidebarReducer;
exports.getInitialState = getInitialState;
var _get_field_list = require("./get_field_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
let DiscoverSidebarReducerActionType = exports.DiscoverSidebarReducerActionType = /*#__PURE__*/function (DiscoverSidebarReducerActionType) {
  DiscoverSidebarReducerActionType["RESET"] = "RESET";
  DiscoverSidebarReducerActionType["DATA_VIEW_SWITCHED"] = "DATA_VIEW_SWITCHED";
  DiscoverSidebarReducerActionType["DOCUMENTS_LOADED"] = "DOCUMENTS_LOADED";
  DiscoverSidebarReducerActionType["DOCUMENTS_LOADING"] = "DOCUMENTS_LOADING";
  return DiscoverSidebarReducerActionType;
}({});
let DiscoverSidebarReducerStatus = exports.DiscoverSidebarReducerStatus = /*#__PURE__*/function (DiscoverSidebarReducerStatus) {
  DiscoverSidebarReducerStatus["INITIAL"] = "INITIAL";
  DiscoverSidebarReducerStatus["PROCESSING"] = "PROCESSING";
  DiscoverSidebarReducerStatus["COMPLETED"] = "COMPLETED";
  return DiscoverSidebarReducerStatus;
}({});
function getInitialState(dataView) {
  return {
    dataView,
    allFields: null,
    fieldCounts: null,
    status: DiscoverSidebarReducerStatus.INITIAL
  };
}
function discoverSidebarReducer(state, action) {
  switch (action.type) {
    case DiscoverSidebarReducerActionType.RESET:
      return getInitialState(action.payload.dataView);
    case DiscoverSidebarReducerActionType.DATA_VIEW_SWITCHED:
      return state.dataView === action.payload.dataView ? state // already updated in `DOCUMENTS_LOADED`
      : {
        ...state,
        dataView: action.payload.dataView,
        fieldCounts: null,
        allFields: null,
        status: state.status === DiscoverSidebarReducerStatus.COMPLETED ? DiscoverSidebarReducerStatus.INITIAL : state.status
      };
    case DiscoverSidebarReducerActionType.DOCUMENTS_LOADING:
      return {
        ...state,
        fieldCounts: null,
        allFields: action.payload.isEsqlMode ? null : state.allFields,
        status: DiscoverSidebarReducerStatus.PROCESSING
      };
    case DiscoverSidebarReducerActionType.DOCUMENTS_LOADED:
      const mappedAndUnmappedFields = action.payload.isEsqlMode ? (0, _get_field_list.getEsqlQueryFieldList)(action.payload.esqlQueryColumns) : (0, _get_field_list.getDataViewFieldList)(action.payload.dataView, action.payload.fieldCounts);
      return {
        ...state,
        dataView: action.payload.dataView,
        fieldCounts: action.payload.fieldCounts,
        allFields: mappedAndUnmappedFields,
        status: mappedAndUnmappedFields === null ? DiscoverSidebarReducerStatus.PROCESSING : DiscoverSidebarReducerStatus.COMPLETED
      };
  }
  return state;
}