"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntaxSuggestionsPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SyntaxSuggestionsPopover = ({
  meta
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const {
    title,
    items,
    footer
  } = meta;
  const helpButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: () => setIsOpen(prev => !prev),
    iconType: "documentation",
    "aria-label": title
  });
  const columns = [{
    field: 'label',
    name: _i18n.i18n.translate('discover.noResults.suggestion.syntaxPopoverDescriptionHeader', {
      defaultMessage: 'Description'
    }),
    width: '200px'
  }, {
    field: 'example',
    name: _i18n.i18n.translate('discover.noResults.suggestion.syntaxPopoverExampleHeader', {
      defaultMessage: 'Example'
    }),
    render: example => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, example)
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: helpButton,
    isOpen: isOpen,
    display: "inlineBlock",
    panelPaddingSize: "none",
    closePopover: () => setIsOpen(false),
    initialFocus: "#querySyntaxBasicTableId"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "eui-yScroll",
    css: (0, _react2.css)`
          max-height: 40vh;
          max-width: 500px;
        `,
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    id: "querySyntaxBasicTableId",
    tableCaption: title,
    items: items,
    compressed: true,
    rowHeader: "label",
    columns: columns
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, footer), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })));
};
exports.SyntaxSuggestionsPopover = SyntaxSuggestionsPopover;