"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SortDirection = void 0;
exports.getFirstSortableField = getFirstSortableField;
exports.reverseSortDir = reverseSortDir;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
let SortDirection = exports.SortDirection = /*#__PURE__*/function (SortDirection) {
  SortDirection["asc"] = "asc";
  SortDirection["desc"] = "desc";
  return SortDirection;
}({});
/**
 * The list of field names that are allowed for sorting, but not included in
 * data view fields.
 */
const META_FIELD_NAMES = ['_seq_no', '_doc', '_uid'];

/**
 * Returns a field from the intersection of the set of sortable fields in the
 * given data view and a given set of candidate field names.
 */
function getFirstSortableField(dataView, fieldNames) {
  const sortableFields = fieldNames.filter(fieldName => META_FIELD_NAMES.includes(fieldName) || (dataView.fields.getByName(fieldName) || {
    sortable: false
  }).sortable);
  return sortableFields[0];
}

/**
 * Return the reversed sort direction.
 */
function reverseSortDir(sortDirection) {
  return sortDirection === SortDirection.asc ? SortDirection.desc : SortDirection.asc;
}