"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverESQLLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _esqlUtils = require("@kbn/esql-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class DiscoverESQLLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", _deeplinksAnalytics.DISCOVER_ESQL_LOCATOR);
    (0, _defineProperty2.default)(this, "getLocation", async () => {
      const {
        discoverAppLocator,
        getIndices
      } = this.deps;
      const indexName = await (0, _esqlUtils.getIndexForESQLQuery)({
        dataViews: {
          getIndices
        }
      });
      const esql = (0, _esqlUtils.getInitialESQLQuery)(indexName !== null && indexName !== void 0 ? indexName : '*');
      const params = {
        query: {
          esql
        }
      };
      return await discoverAppLocator.getLocation(params);
    });
    this.deps = deps;
  }
}
exports.DiscoverESQLLocatorDefinition = DiscoverESQLLocatorDefinition;