"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  LOGS_EXPLORER_PROFILE_ID: true,
  CONTENT_FIELD: true,
  RESOURCE_FIELD: true,
  DATA_GRID_COLUMN_WIDTH_SMALL: true,
  DATA_GRID_COLUMN_WIDTH_MEDIUM: true,
  ACTIONS_COLUMN_WIDTH: true,
  RESOURCE_FIELD_CONFIGURATION: true,
  CONTENT_FIELD_CONFIGURATION: true,
  SMART_FALLBACK_FIELDS: true,
  DEFAULT_COLUMNS: true,
  DEFAULT_ROWS_PER_PAGE: true,
  FILTER_OUT_FIELDS_PREFIXES_FOR_CONTENT: true,
  DEFAULT_ALLOWED_DATA_VIEWS: true,
  DEFAULT_ALLOWED_LOGS_DATA_VIEWS: true
};
exports.SMART_FALLBACK_FIELDS = exports.RESOURCE_FIELD_CONFIGURATION = exports.RESOURCE_FIELD = exports.LOGS_EXPLORER_PROFILE_ID = exports.FILTER_OUT_FIELDS_PREFIXES_FOR_CONTENT = exports.DEFAULT_ROWS_PER_PAGE = exports.DEFAULT_COLUMNS = exports.DEFAULT_ALLOWED_LOGS_DATA_VIEWS = exports.DEFAULT_ALLOWED_DATA_VIEWS = exports.DATA_GRID_COLUMN_WIDTH_SMALL = exports.DATA_GRID_COLUMN_WIDTH_MEDIUM = exports.CONTENT_FIELD_CONFIGURATION = exports.CONTENT_FIELD = exports.ACTIONS_COLUMN_WIDTH = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _field_constants = require("@kbn/discover-utils/src/field_constants");
Object.keys(_field_constants).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _field_constants[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _field_constants[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LOGS_EXPLORER_PROFILE_ID = exports.LOGS_EXPLORER_PROFILE_ID = 'logs-explorer';

// Virtual column fields
const CONTENT_FIELD = exports.CONTENT_FIELD = 'content';
const RESOURCE_FIELD = exports.RESOURCE_FIELD = 'resource';

// Sizing
const DATA_GRID_COLUMN_WIDTH_SMALL = exports.DATA_GRID_COLUMN_WIDTH_SMALL = 240;
const DATA_GRID_COLUMN_WIDTH_MEDIUM = exports.DATA_GRID_COLUMN_WIDTH_MEDIUM = 320;
const ACTIONS_COLUMN_WIDTH = exports.ACTIONS_COLUMN_WIDTH = 80;
const RESOURCE_FIELD_CONFIGURATION = exports.RESOURCE_FIELD_CONFIGURATION = {
  type: 'smart-field',
  smartField: RESOURCE_FIELD,
  fallbackFields: [_discoverUtils.fieldConstants.HOST_NAME_FIELD, _discoverUtils.fieldConstants.SERVICE_NAME_FIELD],
  width: DATA_GRID_COLUMN_WIDTH_MEDIUM
};
const CONTENT_FIELD_CONFIGURATION = exports.CONTENT_FIELD_CONFIGURATION = {
  type: 'smart-field',
  smartField: CONTENT_FIELD,
  fallbackFields: [_discoverUtils.fieldConstants.MESSAGE_FIELD]
};
const SMART_FALLBACK_FIELDS = exports.SMART_FALLBACK_FIELDS = {
  [CONTENT_FIELD]: CONTENT_FIELD_CONFIGURATION,
  [RESOURCE_FIELD]: RESOURCE_FIELD_CONFIGURATION
};

// UI preferences
const DEFAULT_COLUMNS = exports.DEFAULT_COLUMNS = [RESOURCE_FIELD_CONFIGURATION, CONTENT_FIELD_CONFIGURATION];
const DEFAULT_ROWS_PER_PAGE = exports.DEFAULT_ROWS_PER_PAGE = 100;

// List of prefixes which needs to be filtered out for Display in Content Column
const FILTER_OUT_FIELDS_PREFIXES_FOR_CONTENT = exports.FILTER_OUT_FIELDS_PREFIXES_FOR_CONTENT = ['_',
// Filter fields like '_id', '_score'
'@timestamp', 'agent.', 'elastic_agent.', 'data_stream.', 'ecs.', 'host.', 'container.', 'cloud.', 'kubernetes.', 'orchestrator.', 'log.', 'service.'];
const DEFAULT_ALLOWED_DATA_VIEWS = exports.DEFAULT_ALLOWED_DATA_VIEWS = ['logs', 'auditbeat', 'filebeat', 'winlogbeat'];
const DEFAULT_ALLOWED_LOGS_DATA_VIEWS = exports.DEFAULT_ALLOWED_LOGS_DATA_VIEWS = ['logs', 'auditbeat', 'filebeat', 'winlogbeat'];