"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isEsqlSource = exports.isDataViewSource = exports.isDataSourceType = exports.createEsqlDataSource = exports.createDataViewDataSource = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createDataViewDataSource = ({
  dataViewId
}) => ({
  type: _types.DataSourceType.DataView,
  dataViewId
});
exports.createDataViewDataSource = createDataViewDataSource;
const createEsqlDataSource = () => ({
  type: _types.DataSourceType.Esql
});
exports.createEsqlDataSource = createEsqlDataSource;
const isDataSourceType = (dataSource, type) => (dataSource === null || dataSource === void 0 ? void 0 : dataSource.type) === type;
exports.isDataSourceType = isDataSourceType;
const isDataViewSource = dataSource => isDataSourceType(dataSource, _types.DataSourceType.DataView);
exports.isDataViewSource = isDataViewSource;
const isEsqlSource = dataSource => isDataSourceType(dataSource, _types.DataSourceType.Esql);
exports.isEsqlSource = isEsqlSource;