"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverAppLocatorDefinition = exports.DISCOVER_APP_LOCATOR = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _esQuery = require("@kbn/es-query");
var _data_sources = require("./data_sources");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const DISCOVER_APP_LOCATOR = exports.DISCOVER_APP_LOCATOR = 'DISCOVER_APP_LOCATOR';

/**
 * Location state of scoped history (history instance of Kibana Platform application service)
 */

class DiscoverAppLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", DISCOVER_APP_LOCATOR);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const {
        useHash = this.deps.useHash,
        filters,
        dataViewId,
        indexPatternId,
        dataViewSpec,
        query,
        refreshInterval,
        savedSearchId,
        timeRange,
        searchSessionId,
        columns,
        grid,
        savedQuery,
        sort,
        interval,
        viewMode,
        hideAggregatedPreview,
        breakdownField,
        isAlertResults
      } = params;
      const savedSearchPath = savedSearchId ? `view/${encodeURIComponent(savedSearchId)}` : '';
      const appState = {};
      const queryState = {};
      const {
        isFilterPinned
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
      if (query) appState.query = query;
      if (filters && filters.length) appState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => !isFilterPinned(f));
      if (indexPatternId) appState.dataSource = (0, _data_sources.createDataViewDataSource)({
        dataViewId: indexPatternId
      });
      if (dataViewId) appState.dataSource = (0, _data_sources.createDataViewDataSource)({
        dataViewId
      });
      if ((0, _esQuery.isOfAggregateQueryType)(query)) appState.dataSource = (0, _data_sources.createEsqlDataSource)();
      if (columns) appState.columns = columns;
      if (grid) appState.grid = grid;
      if (savedQuery) appState.savedQuery = savedQuery;
      if (sort) appState.sort = sort;
      if (interval) appState.interval = interval;
      if (timeRange) queryState.time = timeRange;
      if (filters && filters.length) queryState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => isFilterPinned(f));
      if (refreshInterval) queryState.refreshInterval = refreshInterval;
      if (viewMode) appState.viewMode = viewMode;
      if (hideAggregatedPreview) appState.hideAggregatedPreview = hideAggregatedPreview;
      if (breakdownField) appState.breakdownField = breakdownField;
      const state = {};
      if (dataViewSpec) state.dataViewSpec = dataViewSpec;
      if (isAlertResults) state.isAlertResults = isAlertResults;
      let path = `#/${savedSearchPath}`;
      if (searchSessionId) {
        path = `${path}?searchSessionId=${searchSessionId}`;
      }
      if (Object.keys(queryState).length) {
        path = this.deps.setStateToKbnUrl('_g', queryState, {
          useHash
        }, path);
      }
      if (Object.keys(appState).length) {
        path = this.deps.setStateToKbnUrl('_a', appState, {
          useHash
        }, path);
      }
      return {
        app: 'discover',
        path,
        state
      };
    });
    this.deps = deps;
  }
}
exports.DiscoverAppLocatorDefinition = DiscoverAppLocatorDefinition;