"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDatasetQualityESClient = createDatasetQualityESClient;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createDatasetQualityESClient(esClient) {
  return {
    async search(searchParams) {
      return esClient.search(searchParams);
    },
    async msearch(index = {}, searches) {
      return esClient.msearch({
        searches: searches.map(search => [index, search]).flat()
      });
    },
    async fieldCaps(params) {
      return esClient.fieldCaps(params);
    }
  };
}