"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.integrationsRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _default_api_types = require("../../types/default_api_types");
var _create_datasets_quality_server_route = require("../create_datasets_quality_server_route");
var _get_integrations = require("./get_integrations");
var _get_integration_dashboards = require("./get_integration_dashboards");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const integrationsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/integrations',
  params: t.type({
    query: _default_api_types.typeRt
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      params,
      plugins,
      logger
    } = resources;
    const fleetPluginStart = await plugins.fleet.start();
    const packageClient = fleetPluginStart.packageService.asInternalUser;
    const integrations = await (0, _get_integrations.getIntegrations)({
      packageClient,
      logger,
      ...params.query
    });
    return {
      integrations
    };
  }
});
const integrationDashboardsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/integrations/{integration}/dashboards',
  params: t.type({
    path: t.type({
      integration: t.string
    })
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params,
      plugins
    } = resources;
    const {
      integration
    } = params.path;
    const {
      savedObjects
    } = await context.core;
    const fleetPluginStart = await plugins.fleet.start();
    const packageClient = fleetPluginStart.packageService.asInternalUser;
    const integrationDashboards = await (0, _get_integration_dashboards.getIntegrationDashboards)(packageClient, savedObjects.client, integration);
    return {
      dashboards: integrationDashboards
    };
  }
});
const integrationsRouteRepository = exports.integrationsRouteRepository = {
  ...integrationsRoute,
  ...integrationDashboardsRoute
};