"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataStreamsRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _default_api_types = require("../../types/default_api_types");
var _create_datasets_quality_server_route = require("../create_datasets_quality_server_route");
var _services = require("../../services");
var _get_data_stream_details = require("./get_data_stream_details");
var _get_data_streams = require("./get_data_streams");
var _get_data_streams_stats = require("./get_data_streams_stats");
var _get_degraded_docs = require("./get_degraded_docs");
var _get_non_aggregatable_data_streams = require("./get_non_aggregatable_data_streams");
var _get_degraded_fields = require("./get_degraded_fields");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/stats',
  params: t.type({
    query: t.intersection([_default_api_types.typeRt, t.partial({
      datasetQuery: t.string
    })])
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params,
      getEsCapabilities
    } = resources;
    const coreContext = await context.core;
    const sizeStatsAvailable = !(await getEsCapabilities()).serverless;

    // Query datastreams as the current user as the Kibana internal user may not have all the required permissions
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    const {
      items,
      datasetUserPrivileges
    } = await (0, _get_data_streams.getDataStreams)({
      esClient,
      ...params.query,
      uncategorisedOnly: false
    });
    const privilegedDataStreams = items.filter(stream => {
      return stream.userPrivileges.canMonitor;
    });
    const dataStreamsStats = await (0, _get_data_streams_stats.getDataStreamsStats)({
      esClient,
      dataStreams: privilegedDataStreams.map(stream => stream.name),
      sizeStatsAvailable
    });
    return {
      datasetUserPrivileges,
      dataStreamsStats: (0, _lodash.values)((0, _lodash.merge)((0, _lodash.keyBy)(items, 'name'), (0, _lodash.keyBy)(dataStreamsStats.items, 'name')))
    };
  }
});
const degradedDocsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/degraded_docs',
  params: t.type({
    query: t.intersection([_default_api_types.rangeRt, _default_api_types.typeRt, t.partial({
      datasetQuery: t.string
    })])
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params
    } = resources;
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    await _services.datasetQualityPrivileges.throwIfCannotReadDataset(esClient, params.query.type, params.query.datasetQuery);
    const degradedDocs = await (0, _get_degraded_docs.getDegradedDocsPaginated)({
      esClient,
      ...params.query
    });
    return {
      degradedDocs
    };
  }
});
const nonAggregatableDatasetsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/non_aggregatable',
  params: t.type({
    query: t.intersection([_default_api_types.rangeRt, _default_api_types.typeRt, t.partial({
      dataStream: t.string
    })])
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params
    } = resources;
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    await _services.datasetQualityPrivileges.throwIfCannotReadDataset(esClient, params.query.type);
    return await (0, _get_non_aggregatable_data_streams.getNonAggregatableDataStreams)({
      esClient,
      ...params.query
    });
  }
});
const degradedFieldsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/{dataStream}/degraded_fields',
  params: t.type({
    path: t.type({
      dataStream: t.string
    }),
    query: _default_api_types.rangeRt
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params
    } = resources;
    const {
      dataStream
    } = params.path;
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    return await (0, _get_degraded_fields.getDegradedFields)({
      esClient,
      dataStream,
      ...params.query
    });
  }
});
const dataStreamSettingsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/{dataStream}/settings',
  params: t.type({
    path: t.type({
      dataStream: t.string
    })
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params
    } = resources;
    const {
      dataStream
    } = params.path;
    const coreContext = await context.core;

    // Query datastreams as the current user as the Kibana internal user may not have all the required permissions
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    const dataStreamSettings = await (0, _get_data_stream_details.getDataStreamSettings)({
      esClient,
      dataStream
    });
    return dataStreamSettings;
  }
});
const dataStreamDetailsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/{dataStream}/details',
  params: t.type({
    path: t.type({
      dataStream: t.string
    }),
    query: _default_api_types.rangeRt
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params,
      getEsCapabilities
    } = resources;
    const {
      dataStream
    } = params.path;
    const {
      start,
      end
    } = params.query;
    const coreContext = await context.core;

    // Query datastreams as the current user as the Kibana internal user may not have all the required permissions
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    const sizeStatsAvailable = !(await getEsCapabilities()).serverless;
    const dataStreamDetails = await (0, _get_data_stream_details.getDataStreamDetails)({
      esClient,
      dataStream,
      start,
      end,
      sizeStatsAvailable
    });
    return dataStreamDetails;
  }
});
const dataStreamsRouteRepository = exports.dataStreamsRouteRepository = {
  ...statsRoute,
  ...degradedDocsRoute,
  ...nonAggregatableDatasetsRoute,
  ...degradedFieldsRoute,
  ...dataStreamDetailsRoute,
  ...dataStreamSettingsRoute
};