"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDegradedFields = getDegradedFields;
var _server = require("@kbn/observability-plugin/server");
var _constants = require("../../../../common/constants");
var _utils = require("../../../utils");
var _es_fields = require("../../../../common/es_fields");
var _get_interval = require("./get_interval");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDegradedFields({
  esClient,
  start,
  end,
  dataStream
}) {
  var _response$aggregation, _response$aggregation2;
  const fieldInterval = (0, _get_interval.getFieldIntervalInSeconds)({
    start,
    end
  });
  const datasetQualityESClient = (0, _utils.createDatasetQualityESClient)(esClient);
  const filterQuery = [...(0, _server.rangeQuery)(start, end)];
  const mustQuery = [...(0, _server.existsQuery)(_es_fields._IGNORED)];
  const aggs = {
    degradedFields: {
      terms: {
        size: _constants.MAX_DEGRADED_FIELDS,
        field: _es_fields._IGNORED
      },
      aggs: {
        lastOccurrence: {
          max: {
            field: _es_fields.TIMESTAMP
          }
        },
        timeSeries: {
          date_histogram: {
            field: _es_fields.TIMESTAMP,
            fixed_interval: `${fieldInterval}s`,
            min_doc_count: 0,
            extended_bounds: {
              min: start,
              max: end
            }
          }
        }
      }
    }
  };
  const response = await datasetQualityESClient.search({
    index: dataStream,
    size: 0,
    query: {
      bool: {
        filter: filterQuery,
        must: mustQuery
      }
    },
    aggs
  });
  return {
    degradedFields: (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.degradedFields.buckets.map(bucket => ({
      name: bucket.key,
      count: bucket.doc_count,
      lastOccurrence: bucket.lastOccurrence.value,
      timeSeries: bucket.timeSeries.buckets.map(timeSeriesBucket => ({
        x: timeSeriesBucket.key,
        y: timeSeriesBucket.doc_count
      }))
    }))) !== null && _response$aggregation !== void 0 ? _response$aggregation : []
  };
}