"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamsStats = getDataStreamsStats;
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDataStreamsStats({
  esClient,
  dataStreams,
  sizeStatsAvailable = true
}) {
  if (!dataStreams.length) {
    return {
      items: []
    };
  }
  const matchingDataStreamsStats = await _services.dataStreamService.getStreamsStats(esClient, dataStreams);
  const indicesDocsCount = sizeStatsAvailable ? _services.indexStatsService.getIndicesDocCounts(esClient, dataStreams) : Promise.resolve(null);
  const [indicesDocsCountStats, dataStreamsStats] = await Promise.all([indicesDocsCount, matchingDataStreamsStats]);
  const mappedDataStreams = dataStreamsStats.map(dataStream => {
    var _dataStream$store_siz;
    return {
      name: dataStream.data_stream,
      size: (_dataStream$store_siz = dataStream.store_size) === null || _dataStream$store_siz === void 0 ? void 0 : _dataStream$store_siz.toString(),
      sizeBytes: dataStream.store_size_bytes,
      lastActivity: dataStream.maximum_timestamp,
      totalDocs: sizeStatsAvailable ? indicesDocsCountStats.docsCountPerDataStream[dataStream.data_stream] || 0 : null
    };
  });
  return {
    items: mappedDataStreams
  };
}