"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreams = getDataStreams;
var _constants = require("../../../../common/constants");
var _utils = require("../../../../common/utils");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDataStreams(options) {
  const {
    esClient,
    type = _constants.DEFAULT_DATASET_TYPE,
    datasetQuery,
    uncategorisedOnly
  } = options;
  const datasetName = (0, _utils.streamPartsToIndexPattern)({
    typePattern: type,
    datasetPattern: datasetQuery ? `*${datasetQuery}*` : '*-*'
  });
  const datasetUserPrivileges = await _services.datasetQualityPrivileges.getDatasetPrivileges(esClient, datasetName);
  if (!datasetUserPrivileges.canMonitor) {
    return {
      items: [],
      datasetUserPrivileges
    };
  }
  const allDataStreams = await _services.dataStreamService.getMatchingDataStreams(esClient, datasetName);
  const filteredDataStreams = uncategorisedOnly ? allDataStreams.filter(stream => {
    return !stream._meta || !stream._meta.managed_by || stream._meta.managed_by !== 'fleet';
  }) : allDataStreams;
  const dataStreamsPrivileges = filteredDataStreams.length ? await _services.datasetQualityPrivileges.getHasIndexPrivileges(esClient, filteredDataStreams.map(({
    name
  }) => name), ['monitor']) : {};
  const mappedDataStreams = filteredDataStreams.map(dataStream => {
    var _dataStream$_meta, _dataStream$_meta$pac;
    return {
      name: dataStream.name,
      integration: (_dataStream$_meta = dataStream._meta) === null || _dataStream$_meta === void 0 ? void 0 : (_dataStream$_meta$pac = _dataStream$_meta.package) === null || _dataStream$_meta$pac === void 0 ? void 0 : _dataStream$_meta$pac.name,
      userPrivileges: {
        canMonitor: dataStreamsPrivileges[dataStream.name]
      }
    };
  });
  return {
    items: mappedDataStreams,
    datasetUserPrivileges
  };
}