"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _routes = require("./routes");
var _register_routes = require("./routes/register_routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DatasetQualityServerPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core, plugins) {
    this.logger.debug('dataset_quality: Setup');
    const resourcePlugins = (0, _lodash.mapValues)(plugins, (value, key) => {
      return {
        setup: value,
        start: () => core.getStartServices().then(services => {
          const [, pluginsStartContracts] = services;
          return pluginsStartContracts[key];
        })
      };
    });
    const getEsCapabilities = async () => {
      return await core.getStartServices().then(services => {
        const [coreStart] = services;
        return coreStart.elasticsearch.getCapabilities();
      });
    };
    (0, _register_routes.registerRoutes)({
      core,
      logger: this.logger,
      repository: (0, _routes.getDatasetQualityServerRouteRepository)(),
      plugins: resourcePlugins,
      getEsCapabilities
    });
    return {};
  }
  start() {
    this.logger.debug('dataset_quality: Started');
    return {};
  }
}
exports.DatasetQualityServerPlugin = DatasetQualityServerPlugin;