"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateDatasets = generateDatasets;
var _utils = require("../../common/utils");
var _data_stream_stat = require("../../common/data_streams_stats/data_stream_stat");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function generateDatasets(dataStreamStats = [], degradedDocStats = [], integrations) {
  if (!dataStreamStats.length && !integrations.length) {
    return [];
  }
  const {
    datasetIntegrationMap,
    integrationsMap
  } = integrations.reduce((acc, integration) => {
    return {
      datasetIntegrationMap: {
        ...acc.datasetIntegrationMap,
        ...Object.keys(integration.datasets).reduce((datasetsAcc, dataset) => Object.assign(datasetsAcc, {
          [dataset]: {
            integration,
            title: integration.datasets[dataset]
          }
        }), {})
      },
      integrationsMap: {
        ...acc.integrationsMap,
        [integration.name]: integration
      }
    };
  }, {
    datasetIntegrationMap: {},
    integrationsMap: {}
  });
  if (!dataStreamStats.length) {
    return degradedDocStats.map(degradedDocStat => _data_stream_stat.DataStreamStat.fromDegradedDocStat({
      degradedDocStat,
      datasetIntegrationMap
    }));
  }
  const degradedMap = degradedDocStats.reduce((degradedMapAcc, {
    dataset,
    percentage,
    count,
    docsCount,
    quality
  }) => Object.assign(degradedMapAcc, {
    [dataset]: {
      percentage,
      count,
      docsCount,
      quality: (0, _utils.mapPercentageToQuality)(percentage)
    }
  }), {});
  return dataStreamStats === null || dataStreamStats === void 0 ? void 0 : dataStreamStats.map(dataStream => {
    var _datasetIntegrationMa, _datasetIntegrationMa2, _datasetIntegrationMa3, _dataStream$integrati;
    const dataset = _data_stream_stat.DataStreamStat.create(dataStream);
    return {
      ...dataset,
      title: ((_datasetIntegrationMa = datasetIntegrationMap[dataset.name]) === null || _datasetIntegrationMa === void 0 ? void 0 : _datasetIntegrationMa.title) || dataset.title,
      integration: (_datasetIntegrationMa2 = (_datasetIntegrationMa3 = datasetIntegrationMap[dataset.name]) === null || _datasetIntegrationMa3 === void 0 ? void 0 : _datasetIntegrationMa3.integration) !== null && _datasetIntegrationMa2 !== void 0 ? _datasetIntegrationMa2 : integrationsMap[(_dataStream$integrati = dataStream.integration) !== null && _dataStream$integrati !== void 0 ? _dataStream$integrati : ''],
      degradedDocs: degradedMap[dataset.rawName] || dataset.degradedDocs
    };
  });
}