"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.noDatasetSelected = exports.fetchNonAggregatableDatasetsFailedNotifier = exports.fetchIntegrationsFailedNotifier = exports.fetchIntegrationDashboardsFailedNotifier = exports.fetchDegradedStatsFailedNotifier = exports.fetchDatasetStatsFailedNotifier = exports.fetchDatasetSettingsFailedNotifier = exports.fetchDatasetDetailsFailedNotifier = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchDatasetStatsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchDatasetStatsFailed', {
      defaultMessage: "We couldn't get your data sets."
    }),
    text: error.message
  });
};
exports.fetchDatasetStatsFailedNotifier = fetchDatasetStatsFailedNotifier;
const fetchDatasetDetailsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchDatasetDetailsFailed', {
      defaultMessage: "We couldn't get your data set details."
    }),
    text: error.message
  });
};
exports.fetchDatasetDetailsFailedNotifier = fetchDatasetDetailsFailedNotifier;
const fetchDatasetSettingsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchDatasetSettingsFailed', {
      defaultMessage: "Data set settings couldn't be loaded."
    }),
    text: error.message
  });
};
exports.fetchDatasetSettingsFailedNotifier = fetchDatasetSettingsFailedNotifier;
const fetchDegradedStatsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchDegradedStatsFailed', {
      defaultMessage: "We couldn't get your degraded docs information."
    }),
    text: error.message
  });
};
exports.fetchDegradedStatsFailedNotifier = fetchDegradedStatsFailedNotifier;
const fetchNonAggregatableDatasetsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchNonAggregatableDatasetsFailed', {
      defaultMessage: "We couldn't get non aggregatable datasets information."
    }),
    text: error.message
  });
};
exports.fetchNonAggregatableDatasetsFailedNotifier = fetchNonAggregatableDatasetsFailedNotifier;
const fetchIntegrationDashboardsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchIntegrationDashboardsFailed', {
      defaultMessage: "We couldn't get your integration dashboards."
    }),
    text: error.message
  });
};
exports.fetchIntegrationDashboardsFailedNotifier = fetchIntegrationDashboardsFailedNotifier;
const fetchIntegrationsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchIntegrationsFailed', {
      defaultMessage: "We couldn't get your integrations."
    }),
    text: error.message
  });
};
exports.fetchIntegrationsFailedNotifier = fetchIntegrationsFailedNotifier;
const noDatasetSelected = exports.noDatasetSelected = _i18n.i18n.translate('xpack.datasetQuality.fetchDatasetDetailsFailed.noDatasetSelected', {
  defaultMessage: 'No data set have been selected'
});