"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_CONTEXT = void 0;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONE_MINUTE_IN_MS = 60000;
const DEFAULT_CONTEXT = exports.DEFAULT_CONTEXT = {
  type: _constants.DEFAULT_DATASET_TYPE,
  table: {
    page: 0,
    rowsPerPage: 10,
    sort: {
      field: _constants.DEFAULT_SORT_FIELD,
      direction: _constants.DEFAULT_SORT_DIRECTION
    }
  },
  datasetUserPrivileges: {
    canRead: true,
    canMonitor: true,
    canViewIntegrations: true
  },
  dataStreamStats: [],
  filters: {
    inactive: true,
    fullNames: false,
    timeRange: {
      from: 'now-24h',
      to: 'now',
      refresh: {
        pause: true,
        value: ONE_MINUTE_IN_MS
      }
    },
    integrations: [],
    namespaces: [],
    qualities: []
  },
  flyout: {
    degradedFields: {
      table: {
        page: 0,
        rowsPerPage: 10,
        sort: {
          field: _constants.DEFAULT_DEGRADED_FIELD_SORT_FIELD,
          direction: _constants.DEFAULT_DEGRADED_FIELD_SORT_DIRECTION
        }
      }
    }
  },
  datasets: [],
  isSizeStatsAvailable: true,
  nonAggregatableDatasets: []
};