"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavigationTarget = exports.NavigationSource = exports.DatasetQualityTelemetryEventTypes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let NavigationTarget = exports.NavigationTarget = /*#__PURE__*/function (NavigationTarget) {
  NavigationTarget["Exit"] = "exit";
  NavigationTarget["LogsExplorer"] = "logs_explorer";
  NavigationTarget["Discover"] = "discover";
  NavigationTarget["Lens"] = "lens";
  NavigationTarget["Integration"] = "integration";
  NavigationTarget["IndexTemplate"] = "index_template";
  NavigationTarget["Dashboard"] = "dashboard";
  NavigationTarget["Hosts"] = "hosts";
  NavigationTarget["Services"] = "services";
  return NavigationTarget;
}({});
/**
 * Source UI component that triggered the navigation
 */
let NavigationSource = exports.NavigationSource = /*#__PURE__*/function (NavigationSource) {
  NavigationSource["Header"] = "header";
  NavigationSource["Footer"] = "footer";
  NavigationSource["Summary"] = "summary";
  NavigationSource["Chart"] = "chart";
  NavigationSource["Table"] = "table";
  NavigationSource["ActionMenu"] = "action_menu";
  return NavigationSource;
}({});
let DatasetQualityTelemetryEventTypes = exports.DatasetQualityTelemetryEventTypes = /*#__PURE__*/function (DatasetQualityTelemetryEventTypes) {
  DatasetQualityTelemetryEventTypes["NAVIGATED"] = "Dataset Quality Navigated";
  DatasetQualityTelemetryEventTypes["DETAILS_OPENED"] = "Dataset Quality Dataset Details Opened";
  DatasetQualityTelemetryEventTypes["DETAILS_NAVIGATED"] = "Dataset Quality Dataset Details Navigated";
  return DatasetQualityTelemetryEventTypes;
}({});