"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamDetailsClient = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _api_types = require("../../../common/api_types");
var _data_streams_stats = require("../../../common/data_streams_stats");
var _data_stream_details = require("../../../common/data_stream_details");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataStreamDetailsClient {
  constructor(http) {
    this.http = http;
  }
  async getDataStreamSettings({
    dataStream
  }) {
    const response = await this.http.get(`/internal/dataset_quality/data_streams/${dataStream}/settings`).catch(error => {
      throw new _data_streams_stats.GetDataStreamsStatsError(`Failed to fetch data stream settings": ${error}`, error.body.statusCode);
    });
    const dataStreamSettings = (0, _ioTsUtils.decodeOrThrow)(_api_types.getDataStreamsSettingsResponseRt, message => new _data_streams_stats.GetDataStreamsStatsError(`Failed to decode data stream settings response: ${message}"`))(response);
    return dataStreamSettings;
  }
  async getDataStreamDetails({
    dataStream,
    start,
    end
  }) {
    const response = await this.http.get(`/internal/dataset_quality/data_streams/${dataStream}/details`, {
      query: {
        start,
        end
      }
    }).catch(error => {
      throw new _data_streams_stats.GetDataStreamsStatsError(`Failed to fetch data stream details": ${error}`, error.body.statusCode);
    });
    const dataStreamDetails = (0, _ioTsUtils.decodeOrThrow)(_api_types.getDataStreamsDetailsResponseRt, message => new _data_streams_stats.GetDataStreamsStatsError(`Failed to decode data stream details response: ${message}"`))(response);
    return dataStreamDetails;
  }
  async getDataStreamDegradedFields({
    dataStream,
    start,
    end
  }) {
    const response = await this.http.get(`/internal/dataset_quality/data_streams/${dataStream}/degraded_fields`, {
      query: {
        start,
        end
      }
    }).catch(error => {
      throw new _data_stream_details.GetDataStreamsDetailsError(`Failed to fetch data stream degraded fields": ${error}`, error.body.statusCode);
    });
    return (0, _ioTsUtils.decodeOrThrow)(_api_types.getDataStreamDegradedFieldsResponseRt, message => new _data_stream_details.GetDataStreamsDetailsError(`Failed to decode data stream degraded fields response: ${message}"`))(response);
  }
  async getIntegrationDashboards({
    integration
  }) {
    const response = await this.http.get(`/internal/dataset_quality/integrations/${integration}/dashboards`).catch(error => {
      throw new _data_streams_stats.GetDataStreamsStatsError(`Failed to fetch integration dashboards": ${error}`, error.body.statusCode);
    });
    const integrationDashboards = (0, _ioTsUtils.decodeOrThrow)(_api_types.integrationDashboardsRT, message => new _data_streams_stats.GetDataStreamsStatsError(`Failed to decode integration dashboards response: ${message}"`))(response);
    return integrationDashboards;
  }
}
exports.DataStreamDetailsClient = DataStreamDetailsClient;