"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _telemetry = require("./services/telemetry");
var _dataset_quality = require("./components/dataset_quality");
var _lazy_create_controller = require("./controller/lazy_create_controller");
var _data_streams_stats = require("./services/data_streams_stats");
var _data_stream_details = require("./services/data_stream_details");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DatasetQualityPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "telemetry", new _telemetry.TelemetryService());
  }
  setup(core, plugins) {
    this.telemetry.setup({
      analytics: core.analytics
    });
    return {};
  }
  start(core, plugins) {
    const telemetryClient = this.telemetry.start();
    const dataStreamStatsClient = new _data_streams_stats.DataStreamsStatsService().start({
      http: core.http
    }).client;
    const dataStreamDetailsClient = new _data_stream_details.DataStreamDetailsService().start({
      http: core.http
    }).client;
    const DatasetQuality = (0, _dataset_quality.createDatasetQuality)({
      core,
      plugins,
      telemetryClient
    });
    const createDatasetQualityController = (0, _lazy_create_controller.createDatasetQualityControllerLazyFactory)({
      core,
      dataStreamStatsClient,
      dataStreamDetailsClient
    });
    return {
      DatasetQuality,
      createDatasetQualityController
    };
  }
}
exports.DatasetQualityPlugin = DatasetQualityPlugin;