"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEmptyState = useEmptyState;
var _react = require("@xstate/react");
var _context = require("../components/dataset_quality/context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useEmptyState() {
  const {
    service
  } = (0, _context.useDatasetQualityContext)();
  const canReadDataset = (0, _react.useSelector)(service, state => state.context.datasetUserPrivileges.canRead);
  const isDatasetEmpty = (0, _react.useSelector)(service, state => {
    var _state$context$datase, _state$context$datase2;
    return !state.matches('datasets.fetching') && !state.matches('integrations.fetching') && !state.matches('degradedDocs.fetching') && ((_state$context$datase = (_state$context$datase2 = state.context.datasets) === null || _state$context$datase2 === void 0 ? void 0 : _state$context$datase2.length) !== null && _state$context$datase !== void 0 ? _state$context$datase : 0) === 0;
  });
  return {
    canReadDataset,
    isDatasetEmpty
  };
}