"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDegradedDocsChart = void 0;
var _react = require("react");
var _public = require("@kbn/unified-histogram-plugin/public");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _context = require("../components/dataset_quality/context");
var _constants = require("../../common/constants");
var _utils = require("../../common/utils");
var _lens_attributes = require("../components/flyout/degraded_docs_trend/lens_attributes");
var _use_create_dataview = require("./use_create_dataview");
var _use_redirect_link = require("./use_redirect_link");
var _use_dataset_quality_flyout = require("./use_dataset_quality_flyout");
var _utils2 = require("../utils");
var _use_telemetry = require("./use_telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const exploreDataInLogsExplorerText = _i18n.i18n.translate('xpack.datasetQuality.flyoutChartExploreDataInLogsExplorerText', {
  defaultMessage: 'Explore data in Logs Explorer'
});
const exploreDataInDiscoverText = _i18n.i18n.translate('xpack.datasetQuality.flyoutChartExploreDataInDiscoverText', {
  defaultMessage: 'Explore data in Discover'
});
const openInLensText = _i18n.i18n.translate('xpack.datasetQuality.flyoutChartOpenInLensText', {
  defaultMessage: 'Open in Lens'
});
const ACTION_EXPLORE_IN_LOGS_EXPLORER = 'ACTION_EXPLORE_IN_LOGS_EXPLORER';
const ACTION_OPEN_IN_LENS = 'ACTION_OPEN_IN_LENS';
const useDegradedDocsChart = ({
  dataStream
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      lens
    }
  } = (0, _utils2.useKibanaContextForPlugin)();
  const {
    service
  } = (0, _context.useDatasetQualityContext)();
  const {
    trackDetailsNavigated,
    navigationTargets,
    navigationSources
  } = (0, _use_telemetry.useDatasetDetailsTelemetry)();
  const {
    dataStreamStat,
    timeRange,
    breakdownField
  } = (0, _use_dataset_quality_flyout.useDatasetQualityFlyout)();
  const [isChartLoading, setIsChartLoading] = (0, _react.useState)(undefined);
  const [attributes, setAttributes] = (0, _react.useState)(undefined);
  const {
    dataView
  } = (0, _use_create_dataview.useCreateDataView)({
    indexPatternString: getDataViewIndexPattern(dataStream)
  });
  const breakdownDataViewField = (0, _react.useMemo)(() => getDataViewField(dataView, breakdownField), [breakdownField, dataView]);
  const handleChartLoading = isLoading => {
    setIsChartLoading(isLoading);
  };
  const handleBreakdownFieldChange = (0, _react.useCallback)(field => {
    var _field$name;
    service.send({
      type: 'BREAKDOWN_FIELD_CHANGE',
      breakdownField: (_field$name = field === null || field === void 0 ? void 0 : field.name) !== null && _field$name !== void 0 ? _field$name : null
    });
  }, [service]);
  (0, _react.useEffect)(() => {
    var _dataStreamStat$title;
    const dataStreamName = dataStream !== null && dataStream !== void 0 ? dataStream : _constants.DEFAULT_LOGS_DATA_VIEW;
    const lensAttributes = (0, _lens_attributes.getLensAttributes)({
      color: euiTheme.colors.danger,
      dataStream: dataStreamName,
      datasetTitle: (_dataStreamStat$title = dataStreamStat === null || dataStreamStat === void 0 ? void 0 : dataStreamStat.title) !== null && _dataStreamStat$title !== void 0 ? _dataStreamStat$title : dataStreamName,
      breakdownFieldName: breakdownDataViewField === null || breakdownDataViewField === void 0 ? void 0 : breakdownDataViewField.name
    });
    setAttributes(lensAttributes);
  }, [breakdownDataViewField === null || breakdownDataViewField === void 0 ? void 0 : breakdownDataViewField.name, euiTheme.colors.danger, setAttributes, dataStream, dataStreamStat === null || dataStreamStat === void 0 ? void 0 : dataStreamStat.title]);
  const openInLensCallback = (0, _react.useCallback)(() => {
    if (attributes) {
      trackDetailsNavigated(navigationTargets.Lens, navigationSources.Chart);
      lens.navigateToPrefilledEditor({
        id: '',
        timeRange,
        attributes
      });
    }
  }, [attributes, trackDetailsNavigated, navigationTargets, navigationSources, lens, timeRange]);
  const getOpenInLensAction = (0, _react.useMemo)(() => {
    return {
      id: ACTION_OPEN_IN_LENS,
      type: 'link',
      order: 17,
      getDisplayName() {
        return openInLensText;
      },
      getIconType() {
        return 'visArea';
      },
      async isCompatible() {
        return true;
      },
      async execute() {
        return openInLensCallback();
      }
    };
  }, [openInLensCallback]);
  const redirectLinkProps = (0, _use_redirect_link.useRedirectLink)({
    dataStreamStat: dataStreamStat,
    query: {
      language: 'kuery',
      query: '_ignored:*'
    },
    timeRangeConfig: timeRange,
    breakdownField: breakdownDataViewField === null || breakdownDataViewField === void 0 ? void 0 : breakdownDataViewField.name,
    telemetry: {
      page: 'details',
      navigationSource: navigationSources.Chart
    }
  });
  const getOpenInLogsExplorerAction = (0, _react.useMemo)(() => {
    return {
      id: ACTION_EXPLORE_IN_LOGS_EXPLORER,
      type: 'link',
      getDisplayName() {
        return redirectLinkProps !== null && redirectLinkProps !== void 0 && redirectLinkProps.isLogsExplorerAvailable ? exploreDataInLogsExplorerText : exploreDataInDiscoverText;
      },
      getHref: async () => {
        return redirectLinkProps.linkProps.href;
      },
      getIconType() {
        return 'visTable';
      },
      async isCompatible() {
        return true;
      },
      async execute() {
        return redirectLinkProps.navigate();
      },
      order: 18
    };
  }, [redirectLinkProps]);
  const extraActions = [getOpenInLensAction, getOpenInLogsExplorerAction];
  return {
    attributes,
    dataView,
    breakdown: {
      dataViewField: breakdownDataViewField,
      fieldSupportsBreakdown: breakdownDataViewField ? (0, _public.fieldSupportsBreakdown)(breakdownDataViewField) : true,
      onChange: handleBreakdownFieldChange
    },
    extraActions,
    isChartLoading,
    onChartLoading: handleChartLoading,
    setAttributes,
    setIsChartLoading
  };
};
exports.useDegradedDocsChart = useDegradedDocsChart;
function getDataViewIndexPattern(dataStream) {
  return dataStream ? `${(0, _utils.indexNameToDataStreamParts)(dataStream).type}-*-*` : _constants.DEFAULT_LOGS_DATA_VIEW;
}
function getDataViewField(dataView, fieldName) {
  return fieldName && dataView ? dataView.fields.find(field => field.name === fieldName) : undefined;
}