"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetQualityFlyout = void 0;
var _react = require("@xstate/react");
var _context = require("../components/dataset_quality/context");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDatasetQualityFlyout = () => {
  var _useSelector;
  const {
    services: {
      fieldFormats
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    service
  } = (0, _context.useDatasetQualityContext)();
  const {
    dataset: dataStreamStat,
    datasetSettings: dataStreamSettings,
    datasetDetails: dataStreamDetails,
    insightsTimeRange,
    breakdownField,
    isNonAggregatable
  } = (_useSelector = (0, _react.useSelector)(service, state => state.context.flyout)) !== null && _useSelector !== void 0 ? _useSelector : {};
  const {
    timeRange
  } = (0, _react.useSelector)(service, state => state.context.filters);
  const loadingState = (0, _react.useSelector)(service, state => ({
    dataStreamDetailsLoading: state.matches('flyout.initializing.dataStreamDetails.fetching'),
    dataStreamSettingsLoading: state.matches('flyout.initializing.dataStreamSettings.fetching'),
    datasetIntegrationsLoading: state.matches('flyout.initializing.integrationDashboards.fetching')
  }));
  const canUserAccessDashboards = (0, _react.useSelector)(service, state => !state.matches('flyout.initializing.integrationDashboards.unauthorized'));
  const canUserViewIntegrations = (0, _react.useSelector)(service, state => state.context.datasetUserPrivileges.canViewIntegrations);
  return {
    dataStreamStat,
    dataStreamSettings,
    dataStreamDetails,
    isNonAggregatable,
    fieldFormats,
    timeRange: insightsTimeRange !== null && insightsTimeRange !== void 0 ? insightsTimeRange : timeRange,
    breakdownField,
    loadingState,
    flyoutLoading: !dataStreamStat,
    canUserAccessDashboards,
    canUserViewIntegrations
  };
};
exports.useDatasetQualityFlyout = useDatasetQualityFlyout;