"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetQualityDegradedField = useDatasetQualityDegradedField;
var _react = require("@xstate/react");
var _react2 = require("react");
var _lodash = require("lodash");
var _context = require("../components/dataset_quality/context");
var _constants = require("../../common/constants");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDatasetQualityDegradedField() {
  var _useSelector, _data$length;
  const {
    service
  } = (0, _context.useDatasetQualityContext)();
  const {
    services: {
      fieldFormats
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const degradedFields = (_useSelector = (0, _react.useSelector)(service, state => state.context.flyout.degradedFields)) !== null && _useSelector !== void 0 ? _useSelector : {};
  const {
    data,
    table
  } = degradedFields;
  const {
    page,
    rowsPerPage,
    sort
  } = table;
  const pagination = {
    pageIndex: page,
    pageSize: rowsPerPage,
    totalItemCount: (_data$length = data === null || data === void 0 ? void 0 : data.length) !== null && _data$length !== void 0 ? _data$length : 0,
    hidePerPageOptions: true
  };
  const onTableChange = (0, _react2.useCallback)(options => {
    var _options$sort, _options$sort2;
    service.send({
      type: 'UPDATE_DEGRADED_FIELDS_TABLE_CRITERIA',
      degraded_field_criteria: {
        page: options.page.index,
        rowsPerPage: options.page.size,
        sort: {
          field: ((_options$sort = options.sort) === null || _options$sort === void 0 ? void 0 : _options$sort.field) || _constants.DEFAULT_DEGRADED_FIELD_SORT_FIELD,
          direction: ((_options$sort2 = options.sort) === null || _options$sort2 === void 0 ? void 0 : _options$sort2.direction) || _constants.DEFAULT_DEGRADED_FIELD_SORT_DIRECTION
        }
      }
    });
  }, [service]);
  const renderedItems = (0, _react2.useMemo)(() => {
    const sortedItems = (0, _lodash.orderBy)(data, sort.field, sort.direction);
    return sortedItems.slice(page * rowsPerPage, (page + 1) * rowsPerPage);
  }, [data, sort.field, sort.direction, page, rowsPerPage]);
  const isLoading = (0, _react.useSelector)(service, state => state.matches('flyout.initializing.dataStreamDegradedFields.fetching'));
  return {
    isLoading,
    pagination,
    onTableChange,
    renderedItems,
    sort: {
      sort
    },
    fieldFormats
  };
}