"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPublicStateFromContext = exports.getContextFromPublicState = void 0;
var _dataset_quality_controller = require("../state_machines/dataset_quality_controller");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPublicStateFromContext = context => {
  return {
    table: context.table,
    flyout: context.flyout,
    filters: context.filters
  };
};
exports.getPublicStateFromContext = getPublicStateFromContext;
const getContextFromPublicState = publicState => {
  var _publicState$table, _publicState$table2, _publicState$table3, _publicState$flyout, _publicState$flyout$d, _publicState$flyout2, _publicState$flyout2$, _publicState$flyout2$2;
  return {
    ..._dataset_quality_controller.DEFAULT_CONTEXT,
    table: {
      ..._dataset_quality_controller.DEFAULT_CONTEXT.table,
      ...publicState.table,
      sort: (_publicState$table = publicState.table) !== null && _publicState$table !== void 0 && _publicState$table.sort ? {
        ...((_publicState$table2 = publicState.table) === null || _publicState$table2 === void 0 ? void 0 : _publicState$table2.sort),
        field: (_publicState$table3 = publicState.table) === null || _publicState$table3 === void 0 ? void 0 : _publicState$table3.sort.field
      } : _dataset_quality_controller.DEFAULT_CONTEXT.table.sort
    },
    flyout: {
      ..._dataset_quality_controller.DEFAULT_CONTEXT.flyout,
      ...publicState.flyout,
      degradedFields: {
        table: {
          ..._dataset_quality_controller.DEFAULT_CONTEXT.flyout.degradedFields.table,
          ...((_publicState$flyout = publicState.flyout) === null || _publicState$flyout === void 0 ? void 0 : (_publicState$flyout$d = _publicState$flyout.degradedFields) === null || _publicState$flyout$d === void 0 ? void 0 : _publicState$flyout$d.table),
          sort: (_publicState$flyout2 = publicState.flyout) !== null && _publicState$flyout2 !== void 0 && (_publicState$flyout2$ = _publicState$flyout2.degradedFields) !== null && _publicState$flyout2$ !== void 0 && (_publicState$flyout2$2 = _publicState$flyout2$.table) !== null && _publicState$flyout2$2 !== void 0 && _publicState$flyout2$2.sort ? {
            ...publicState.flyout.degradedFields.table.sort,
            field: publicState.flyout.degradedFields.table.sort.field
          } : _dataset_quality_controller.DEFAULT_CONTEXT.flyout.degradedFields.table.sort
        }
      }
    },
    filters: {
      ..._dataset_quality_controller.DEFAULT_CONTEXT.filters,
      ...publicState.filters
    }
  };
};
exports.getContextFromPublicState = getContextFromPublicState;