"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDatasetQualityControllerFactory = void 0;
var _xstateUtils = require("@kbn/xstate-utils");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _rxjs = require("rxjs");
var _xstate = require("xstate");
var _dataset_quality_controller = require("../state_machines/dataset_quality_controller");
var _public_state = require("./public_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createDatasetQualityControllerFactory = ({
  core,
  dataStreamStatsClient,
  dataStreamDetailsClient
}) => async ({
  initialState = _dataset_quality_controller.DEFAULT_CONTEXT
}) => {
  const initialContext = (0, _public_state.getContextFromPublicState)(initialState !== null && initialState !== void 0 ? initialState : {});
  const machine = (0, _dataset_quality_controller.createDatasetQualityControllerStateMachine)({
    initialContext,
    toasts: core.notifications.toasts,
    dataStreamStatsClient,
    dataStreamDetailsClient
  });
  const service = (0, _xstate.interpret)(machine, {
    devTools: (0, _xstateUtils.getDevToolsOptions)()
  });
  const state$ = (0, _rxjs.from)(service).pipe((0, _rxjs.map)(({
    context
  }) => (0, _public_state.getPublicStateFromContext)(context)), (0, _rxjs.distinctUntilChanged)(_fastDeepEqual.default));
  return {
    state$,
    service
  };
};
exports.createDatasetQualityControllerFactory = createDatasetQualityControllerFactory;