"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationSummary = IntegrationSummary;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _translations = require("../../../common/translations");
var _common = require("../common");
var _fields_list = require("./fields_list");
var _integration_actions_menu = require("./integration_actions_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IntegrationSummary({
  integration,
  dashboardsLoading
}) {
  const {
    name,
    version
  } = integration;
  const integrationActionsMenu = /*#__PURE__*/_react.default.createElement(_integration_actions_menu.IntegrationActionsMenu, {
    integration: integration,
    dashboardsLoading: dashboardsLoading
  });
  return /*#__PURE__*/_react.default.createElement(_fields_list.FieldsList, {
    title: _translations.flyoutIntegrationDetailsText,
    actionsMenu: integrationActionsMenu,
    fields: [{
      fieldTitle: _translations.flyoutIntegrationNameText,
      fieldValue: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        css: (0, _react2.css)`
                width: fit-content;
              `
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_common.IntegrationIcon, {
        integration: integration
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, name))),
      isLoading: false
    }, {
      fieldTitle: _translations.flyoutIntegrationVersionText,
      fieldValue: version,
      isLoading: false
    }]
  });
}