"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSummaryKpis = getSummaryKpis;
var _eui = require("@elastic/eui");
var _get_router_link_props = require("@kbn/router-utils/src/get_router_link_props");
var _constants = require("../../../../common/constants");
var _translations = require("../../../../common/translations");
var _telemetry = require("../../../services/telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSummaryKpis({
  dataStreamDetails,
  timeRange = {
    ..._constants.DEFAULT_TIME_RANGE,
    refresh: _constants.DEFAULT_DATEPICKER_REFRESH
  },
  degradedDocsLinkProps,
  hostsLocator,
  telemetry
}) {
  var _dataStreamDetails$se, _dataStreamDetails$do, _dataStreamDetails$si, _dataStreamDetails$us, _dataStreamDetails$us2, _dataStreamDetails$de;
  const services = (_dataStreamDetails$se = dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.services) !== null && _dataStreamDetails$se !== void 0 ? _dataStreamDetails$se : {};
  const serviceKeys = Object.keys(services);
  const countOfServices = serviceKeys.map(key => services[key].length).reduce((a, b) => a + b, 0);

  // @ts-ignore // TODO: Add link to APM services page when possible - https://github.com/elastic/kibana/issues/179904
  const servicesLink = {
    label: _translations.flyoutShowAllText,
    props: (0, _get_router_link_props.getRouterLinkProps)({
      href: undefined,
      onClick: () => {
        telemetry.trackDetailsNavigated(_telemetry.NavigationTarget.Services, _telemetry.NavigationSource.Summary);
      }
    })
  };
  return [{
    title: _translations.flyoutDocsCountTotalText,
    value: (0, _eui.formatNumber)((_dataStreamDetails$do = dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.docsCount) !== null && _dataStreamDetails$do !== void 0 ? _dataStreamDetails$do : 0, _constants.NUMBER_FORMAT),
    userHasPrivilege: true
  },
  // dataStreamDetails.sizeBytes = null indicates it's Serverless where `_stats` API isn't available
  ...((dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.sizeBytes) !== null // Only show when not in Serverless
  ? [{
    title: _translations.flyoutSizeText,
    value: (0, _eui.formatNumber)((_dataStreamDetails$si = dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.sizeBytes) !== null && _dataStreamDetails$si !== void 0 ? _dataStreamDetails$si : 0, _constants.BYTE_NUMBER_FORMAT),
    userHasPrivilege: (_dataStreamDetails$us = dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : (_dataStreamDetails$us2 = dataStreamDetails.userPrivileges) === null || _dataStreamDetails$us2 === void 0 ? void 0 : _dataStreamDetails$us2.canMonitor) !== null && _dataStreamDetails$us !== void 0 ? _dataStreamDetails$us : true
  }] : []), {
    title: _translations.flyoutServicesText,
    value: formatMetricValueForMax(countOfServices, _constants.MAX_HOSTS_METRIC_VALUE, _constants.NUMBER_FORMAT),
    link: undefined,
    userHasPrivilege: true
  }, getHostsKpi(dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.hosts, timeRange, telemetry, hostsLocator), {
    title: _translations.flyoutDegradedDocsText,
    value: (0, _eui.formatNumber)((_dataStreamDetails$de = dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.degradedDocsCount) !== null && _dataStreamDetails$de !== void 0 ? _dataStreamDetails$de : 0, _constants.NUMBER_FORMAT),
    link: degradedDocsLinkProps && degradedDocsLinkProps.linkProps.href ? {
      label: _translations.flyoutShowAllText,
      props: degradedDocsLinkProps.linkProps
    } : undefined,
    userHasPrivilege: true
  }];
}
function getHostsKpi(dataStreamHosts, timeRange, telemetry, hostsLocator) {
  const hosts = dataStreamHosts !== null && dataStreamHosts !== void 0 ? dataStreamHosts : {};
  const hostKeys = Object.keys(hosts);
  const countOfHosts = hostKeys.map(key => hosts[key].length).reduce(({
    count,
    anyHostExceedsMax
  }, hostCount) => ({
    count: count + hostCount,
    anyHostExceedsMax: anyHostExceedsMax || hostCount > _constants.MAX_HOSTS_METRIC_VALUE
  }), {
    count: 0,
    anyHostExceedsMax: false
  });

  // Create a query so from hostKeys so that (key: value OR key: value2)
  const hostsKuery = hostKeys.filter(key => hosts[key].length > 0).map(key => hosts[key].map(value => `${key}: "${value}"`).join(' OR ')).join(' OR ');
  const hostsUrl = hostsLocator === null || hostsLocator === void 0 ? void 0 : hostsLocator.getRedirectUrl({
    query: {
      language: 'kuery',
      query: hostsKuery
    },
    dateRange: {
      from: timeRange.from,
      to: timeRange.to
    },
    limit: countOfHosts.count
  });

  // @ts-ignore // TODO: Add link to Infra Hosts page when possible
  const hostsLink = {
    label: _translations.flyoutShowAllText,
    props: (0, _get_router_link_props.getRouterLinkProps)({
      href: hostsUrl,
      onClick: () => {
        telemetry.trackDetailsNavigated(_telemetry.NavigationTarget.Hosts, _telemetry.NavigationSource.Summary);
      }
    })
  };
  return {
    title: _translations.flyoutHostsText,
    value: formatMetricValueForMax(countOfHosts.anyHostExceedsMax ? countOfHosts.count + 1 : countOfHosts.count, countOfHosts.count, _constants.NUMBER_FORMAT),
    link: undefined,
    userHasPrivilege: true
  };
}

/**
 * Formats a metric value to show a '+' sign if it's above a max value e.g. 50+
 */
function formatMetricValueForMax(value, max, numberFormat) {
  const exceedsMax = value > max;
  const valueToShow = exceedsMax ? max : value;
  return `${(0, _eui.formatNumber)(valueToShow, numberFormat)}${exceedsMax ? '+' : ''}`;
}